block('b-statistic-phrase-minus-words')(

    def()(function() {
        var phrase = this.ctx.phrase,
            minusWords = u.minusWords.arrayToString(u.phraseFormatter.getMinusWords(phrase)),
            keyWords = u.phraseFormatter.getKeyWords(phrase);

        return applyNext({
            'ctx.minusWords': minusWords || '',
            'ctx.keyWords': keyWords || phrase
        });
    }),

    js()(function() {
        return { minusWords: this.ctx.minusWords };
    }),

    content()(function() {
        var ctx = this.ctx,
            isTooLong = ctx.minusWords.length > ctx.limit;

        return [
            {
                elem: 'truncated-words',
                content: [
                    ctx.keyWords || '',
                    !isTooLong && ctx.minusWords ? { elem: 'minus-words', content: ctx.minusWords } : ''
                ],
                title: ctx.campaignMinusWords ? iget2('b-statistic-phrase-minus-words', 'v-statistike-ne-otobrazhayutsya', 'В статистике не отображаются единые минус-фразы') : ''
            },
            isTooLong ?
                {
                    elem: 'switcher',
                    mix: [{ block: 'b-icon', mods: { 'size-16': 'threedots' } }]
                } :
                ctx.showHelpMark ? { block: 'b-help-link', url: u.getHelpUrl('min-search-price') } : ''
        ];
    }),

    elem('truncated-words')(
        tag()('span'),

        match(function() {
            return this.ctx.title;
        }).attrs()(function() {
            return {
                title: this.ctx.title
            };
        })),

    elem('switcher').tag()('img'),

    elem('minus-words').tag()('em'),

    elem('minus-word').tag()('span')
);
