BEM.DOM.decl('b-statistic-phrase-minus-words', {
    onSetMod: {
        js: function() {
            this.minusWords = this.params.minusWords;
        }
    },

    /**
     * Показывает/скрывает попап
     * @param {Event} e
     */
    togglePopup: function(e) {
        // Если открывашка будет внутри элемента на котором слушается клик - превентим его
        e.preventDefault();

        this.getPopup().toggle(this.elem('switcher'));
    },

    /**
     * Возвращает попап с минус словами, при необходимости создает его
     *
     * @returns {Object}
     */
    getPopup: function() {
        if (this.popup) return this.popup;

        BEM.DOM.append(this.domElem, BEMHTML.apply({
            block: 'popup',
            directions: ['right-middle-middle'],
            content: [
                { elem: 'tail' },
                {
                    block: 'b-statistic-phrase-minus-words',
                    mix: { block: 'popup', elem: 'content' },
                    elem: 'phrase-content',
                    content: this.minusWords
                }
            ]
        }));

        return (this.popup = this.findBlockInside('popup'));
    }
}, {
    /**
     * Подписывает на клик по переключателю попапа
     */
    live: function() {
        this.liveBindTo('switcher', 'click', function(e) {
            this.togglePopup(e);
        });
    }
});
