block('b-statistic-reports-list').elem('content')(

    content()(function() { return iget2('b-statistic-reports-list', 'net-gotovyh-otchetov', 'Нет готовых отчетов'); }),

    match(function() {
        return !!(this.ctx.reports && this.ctx.reports.length);
    })
        .content()(function() {
            var ulogin = this.ctx.ulogin,
                lang = this.ctx.lang,
                url = u.parseUrl(this.ctx.url),
                sortBy = this.ctx.sortBy || 'create_time',
                reverse = this.ctx.reverse,
                currentPage = this.ctx.currentPage,
                totalPages = this.ctx.totalPages,

            // возвращает заголовок столбца с ссылкой сортировки
                getTitleLink = function(sortKey, title) {
                    return {
                        block: 'link',
                        mix: [{
                            block: 'b-statistic-reports-list',
                            elem: 'sort',
                            elemMods: { key: sortKey }
                        }],
                        mods: { pseudo: 'yes' },
                        content: [
                            title,
                            sortBy === sortKey && ('&nbsp;' + (reverse ? '↓' : '↑'))
                        ]
                    };
                };

            return [
                {
                    block: 'b-data-table',
                    mix: [{
                        block: 'b-style-table',
                        mods: { theme: 'gray-list' }
                    }],
                    columns: [
                        {
                            key: 'create_time',
                            title: getTitleLink('date', iget2('b-statistic-reports-list', 'sozdan-135', 'Создан'))
                        },
                        {
                            key: 'camp_names',
                            title: iget2('b-statistic-reports-list', 'otchet', 'Отчет'),
                            transformData: function(row) {
                                var camps = row.camp_names,
                                    campsText = camps.join(', '),
                                    needDropdown = campsText.length > 200,
                                    isSingleCampaign = camps.length === 1,
                                    calculateVideoReportName = function(isSingleCampaign, reportType) {
                                        return {
                                            postclick: isSingleCampaign ? iget2('b-statistic-reports-list', 'video-additions-postclick', '«Видеодополнения (постклик)» по кампании') : iget2('b-statistic-reports-list', 'video-additions-postclick-many', '«Видеодополнения (постклик)» по кампаниям'),
                                            postview: isSingleCampaign ? iget2('b-statistic-reports-list', 'video-additions-postview', '«Видеодополнения (поствью)» по кампании') : iget2('b-statistic-reports-list', 'video-additions-postview-many', '«Видеодополнения (поствью)» по кампаниям')
                                        }[reportType]
                                    },
                                    preText = {
                                        performance: isSingleCampaign ? iget2('b-statistic-reports-list', 'smart-bannery-po-kampanii', '«Смарт-баннеры» по кампании') : iget2('b-statistic-reports-list', 'smart-bannery-po-kampaniyam', '«Смарт-баннеры» по кампаниям'),
                                        dynamic: isSingleCampaign ? iget2('b-statistic-reports-list', 'dinamicheskie-obyavleniya-po-kampanii', '«Динамические объявления» по кампании') : iget2('b-statistic-reports-list', 'dinamicheskie-obyavleniya-po-kampaniyam', '«Динамические объявления» по кампаниям'),
                                        bm: iget2('b-statistic-reports-list', 'dopolnitelnye-relevantnye-frazy-po', '«Дополнительные релевантные фразы» по кампании'),
                                        pdf: isSingleCampaign ? iget2('b-statistic-reports-list', 'po-kampanii', 'По кампании') : iget2('b-statistic-reports-list', 'po-kampaniyam', 'По кампаниям'),
                                        postview: isSingleCampaign ?
                                            iget2('b-statistic-reports-list', 'post-view-report-for-campaign', '«Отчет по поствью-конверсиям» по кампании') :
                                            iget2('b-statistic-reports-list', 'post-view-report-for-campaigns', '«Отчет по поствью-конверсиям» по кампаниям'),
                                        video: calculateVideoReportName(isSingleCampaign, row.report_type )
                                    }[row.type];

                                return needDropdown ? [
                                    preText + ': ' + u.hellipCut(campsText, 200) + ' – ' + iget2('b-statistic-reports-list', 'vsego-103', 'всего') + '&nbsp;',
                                    {
                                        block: 'dropdown',
                                        content: [
                                            {
                                                block: 'link',
                                                mix: [{
                                                    block: 'dropdown',
                                                    elem: 'switcher'
                                                }],
                                                mods: { pseudo: 'yes' },
                                                content: camps.length + '&nbsp;' +
                                                    u.pluralizeWord([iget2('b-statistic-reports-list', 'kampaniya', 'кампания'), iget2('b-statistic-reports-list', 'kampanii-136', 'кампании'), iget2('b-statistic-reports-list', 'kampaniy-102', 'кампаний')], camps.length)
                                            },
                                            {
                                                elem: 'popup',
                                                js: { directions: 'bottom' },
                                                elemMods: { 'has-close': 'yes' },
                                                content: {
                                                    block: 'b-statistic-reports-list',
                                                    elem: 'camps-popup-content',
                                                    content: campsText
                                                }
                                            }
                                        ]
                                    }
                                ] :
                                preText + ': ' + campsText;
                            }
                        },
                        {
                            key: 'period',
                            title: iget2('b-statistic-reports-list', 'period', 'Период'),
                            transformData: function(row) {
                                var from = row.date_from && new Date(row.date_from),
                                    to = row.date_to && new Date(row.date_to),
                                    period = '',
                                    months = [iget2('b-statistic-reports-list', 'yanvarya', 'января'), iget2('b-statistic-reports-list', 'fevralya', 'февраля'), iget2('b-statistic-reports-list', 'marta', 'марта'), iget2('b-statistic-reports-list', 'aprelya', 'апреля'), iget2('b-statistic-reports-list', 'maya', 'мая'), iget2('b-statistic-reports-list', 'iyunya', 'июня'),
                                        iget2('b-statistic-reports-list', 'iyulya', 'июля'), iget2('b-statistic-reports-list', 'avgusta', 'августа'), iget2('b-statistic-reports-list', 'sentyabrya', 'сентября'), iget2('b-statistic-reports-list', 'oktyabrya', 'октября'), iget2('b-statistic-reports-list', 'noyabrya', 'ноября'), iget2('b-statistic-reports-list', 'dekabrya', 'декабря')],

                                    formatDate = function(date) {
                                        return date.getDate() + ' ' + months[date.getMonth()] + ' ' +
                                            (date.getYear() + 1900)
                                    };

                            // интервал
                                if (from && to) {
                                    if (from.getYear() === to.getYear()) {
                                        if (from.getMonth() === to.getMonth()) {
                                            if (from.getDate() !== to.getDate()) {
                                                period = from.getDate();
                                            }
                                        } else {
                                            period = from.getDate() + ' ' + months[from.getMonth()];
                                        }
                                    } else {
                                        period = formatDate(from);
                                    }
                                    period = period + (period ? ' – ' : '') + formatDate(to);
                                } else if (from) {
                                    period = iget2('b-statistic-reports-list', 's-s', 'с {foo}', {
                                        foo: formatDate(from)
                                    });
                                } else if (to) {
                                    period = iget2('b-statistic-reports-list', 'po-s', 'по {foo}', {
                                        foo: formatDate(to)
                                    });
                                } else {
                                    period = iget2('b-statistic-reports-list', 'ves-period', 'Весь период');
                                }

                                if ((row.type === 'pdf' || row.type === 'dynamic' || row.type === 'performance') &&
                                    row.group) {

                                    period += '&nbsp;' + iget2('b-statistic-reports-list', 'po', 'по') + '&nbsp;';

                                    switch (row.group) {
                                        case 'day':
                                            period += iget2('b-statistic-reports-list', 'dnyam', 'дням');
                                            break;
                                        case 'week':
                                            period += iget2('b-statistic-reports-list', 'nedelyam', 'неделям');
                                            break;
                                        case 'month':
                                            period += iget2('b-statistic-reports-list', 'mesyacam', 'месяцам');
                                            break;
                                        case 'year':
                                            period += iget2('b-statistic-reports-list', 'godam', 'годам');
                                    }
                                }

                                return period;
                            }
                        },
                        {
                            key: 'type',
                            title: getTitleLink('format', iget2('b-statistic-reports-list', 'format', 'Формат')),
                            transformData: function(row) {
                                var reportTypeToIconType = {
                                        bm: 'xls',
                                        pdf: 'pdf',
                                        dynamic: 'xls',
                                        performance: 'xls',
                                        video: 'xls',
                                        postview: 'xls',
                                    },
                                    reportTypeToFileExtension = {
                                        bm: '.XLS',
                                        pdf: '.PDF',
                                        dynamic: '.XLS/.XLSX',
                                        performance: '.XLS/.XLSX',
                                        video: '.XLS/.XLSX',
                                        postview: '.XLS/.XLSX',
                                    };

                                return {
                                    block: 'b-statistic-reports-list',
                                    elem: 'file-type-description',
                                    content: [
                                        {
                                            block: 'b-icon',
                                            mix: [{
                                                block: 'b-statistic-reports-list',
                                                elem: 'file-type-icon'
                                            }],
                                            mods: { type: reportTypeToIconType[row.type] }
                                        },
                                        '&nbsp;',
                                        {
                                            block: 'b-statistic-reports-list',
                                            elem: 'file-type',
                                            tag: 'span',
                                            content: reportTypeToFileExtension[row.type]
                                        }
                                    ]
                                };
                            }
                        },
                        {
                            key: 'status',
                            title: iget2('b-statistic-reports-list', 'deystviya', 'Действия'),
                            transformData: function(row) {
                                var removeLinkCtx = !row.no_delete && {
                                    block: 'link',
                                    mods: { 'need-confirm': 'yes' },
                                    confirm: iget2('b-statistic-reports-list', 'vy-uvereny-chto-hotite', 'Вы уверены, что хотите удалить отчет?'),
                                    url: u.formatUrl({
                                        protocol: url.protocol,
                                        host: url.host,
                                        path: url.path,
                                        query: {
                                            cmd: 'delPdfReport',
                                            rid: row.id,
                                            type: row.type,
                                            ulogin: ulogin
                                        }
                                    }),
                                    content: iget2('b-statistic-reports-list', 'udalit', 'удалить')
                                };

                                if (row.status_no_data === 'Yes') {
                                    return [
                                        iget2('b-statistic-reports-list', 'net-dannyh-br-za', 'Нет данных<br/>за&nbsp;выбранный период'),
                                        '<br />',
                                        removeLinkCtx
                                    ];
                                } else if (+row.is_fail) {
                                    return [
                                        iget2('b-statistic-reports-list', 'oshibka-generacii', 'Ошибка генерации'),
                                        '<br/>',
                                        row.type === 'pdf' && {
                                            block: 'link',
                                            url: u.formatUrl('', {
                                                protocol: url.protocol,
                                                host: url.host,
                                                path: url.path,
                                                query: {
                                                    cmd: 'repairPdfReport',
                                                    rid: row.id,
                                                    type: row.type,
                                                    ulogin: ulogin
                                                }
                                            }),
                                            content: iget2('b-statistic-reports-list', 'povtorit', 'повторить')
                                        },
                                        '&nbsp;',
                                        removeLinkCtx
                                    ];
                                } else if (row.status === 'ready' || row.status === 'opened') {
                                    var res = [],
                                        // строит ссылку для скачивания отчета (части отчета)
                                        getDownloadLinkCtx = function(part) {
                                            var cidsUrlPart = row.cids.match(/^\d+$/) ?
                                                    row.cids.match(/(\d+)/g).join('_') + '_' :
                                                    '',
                                                // форматирование даты в path
                                                formatDate = function(dateStr) {
                                                    if (!dateStr) return '';

                                                    var date = new Date(dateStr);

                                                    return date.getDate() + date.getMonth() + (date.getYear() + 1900);
                                                },
                                                path,
                                                query,
                                                datePart = (row.date_from ? row.date_from + '_' : '') +
                                                    (row.date_to ? row.date_to + '_' : '');

                                            if (row.type == 'dynamic') {

                                                path = '/registered/' + datePart + ulogin + '_dynamic_ads' +
                                                    (part ? '.part' + part : '') + '.' + row.file_format;
                                            } else if (row.type == 'performance') {

                                                path = '/registered/' + datePart + ulogin + '_smart_banners' +
                                                    (part ? '.part' + part : '') + '.' + row.file_format;
                                            } else {

                                                path = '/registered/yadirect_' + cidsUrlPart + 'report_' +
                                                    formatDate(row.date_from) + '-' + formatDate(row.date_to) +
                                                        (part ? '.part' + part : '') + '.' +
                                                            (row.type === 'pdf' ? 'pdf' : 'xls');
                                            }

                                            query = {
                                                cmd: 'loadPdfReport',
                                                rid: row.id,
                                                type: row.type,
                                                ulogin: ulogin
                                            };

                                            part && (query.part_id = part);

                                            return {
                                                block: 'link',
                                                url: u.formatUrl({
                                                    path: path,
                                                    query: query
                                                }),
                                                content: part ? part : iget2('b-statistic-reports-list', 'skachat', 'скачать')
                                            };
                                        };

                                    if (row.parts_qty > 1) {
                                        res.push(iget2('b-statistic-reports-list', 'skachat', 'скачать'), '&nbsp;');
                                        row.parts_qty.forEach(function(part, n) {
                                            res.push(getDownloadLinkCtx(n));
                                        });
                                    } else {
                                        res.push(getDownloadLinkCtx());
                                    }

                                    res.push('&nbsp;', removeLinkCtx, '&nbsp;');
                                    lang === 'en' && res.push('<br />', {
                                        block: 'link',
                                        attrs: { target: '_blank' },
                                        url: '/pdf_reports/Appendix.pdf',
                                        content: iget2('b-statistic-reports-list', 'download-appendix', 'download Appendix')
                                    });

                                    return res;

                                } else {
                                    return iget2('b-statistic-reports-list', 'v-processe-br-podgotovki', 'в процессе<br/>подготовки...');
                                }

                            }
                        }
                    ],
                    mixes: {
                        row: [{
                            block: 'b-style-table',
                            elem: 'row'
                        }],
                        headerRow: [
                            {
                                block: 'b-style-table',
                                elem: 'head'
                            },
                            {
                                block: 'b-statistic-reports-list',
                                elem: 'head'
                            }
                        ],
                        cell: [
                            {
                                block: 'b-style-table',
                                elem: 'cell'
                            },
                            {
                                block: 'b-statistic-reports-list',
                                elem: 'cell'
                            }
                        ],
                        headerCell: function(key) {

                            return [
                                {
                                    block: 'b-style-table',
                                    elem: 'cell'
                                },
                                {
                                    block: 'b-statistic-reports-list',
                                    elem: key.replace('_', '-') + '-column'
                                }
                            ];
                        }
                    },
                    rows: this.ctx.reports || []
                },
                totalPages > 1 && {
                    block: 'b-pager',
                    mix: [{
                        block: 'b-statistic-reports-list',
                        elem: 'pager'
                    }],
                    mods: { type: 'js' },
                    currentPage: currentPage,
                    totalPages: totalPages,
                    content: [
                        {
                            elem: 'button-prev',
                            content: '←&nbsp;' + iget2('b-statistic-reports-list', 'predydushchaya', 'предыдущая')
                        },
                        {
                            elem: 'button-next',
                            content: iget2('b-statistic-reports-list', 'sleduyushchaya', 'следующая') + '&nbsp;→'
                        },
                        {
                            elem: 'pages'
                        }
                    ]
                }
            ];
        })
);
