BEM.DOM.decl('b-statistic-reports-list', {

    onSetMod: {

        js: function() {
            this._reportsRequest = BEM.create('i-request_type_ajax', {
                url: this.params.url,
                cache: false,
                dataType: 'json'
            });

            this._sortBy = 'date';
            this._reverse = false;
            this._page = 1;

            this.update();

            BEM.blocks['b-pager'].on(this.domElem, 'change-page', function(e, data) {
                this._page = data.page;
                this.update();
            }, this);
        }

    },

    /**
     * Обновляет таблицу готовых отчетов
     */
    update: function() {
        var pager = this.findBlockOn('pager', 'b-pager');

        pager && pager.setMod('disabled', 'yes');
        this.setMod(this.elem('loading'), 'show', 'yes');

        this._reportsRequest.get({
            cmd: 'listPdfReport',
            ulogin: this.params.ulogin,
            sort: this._sortBy,
            sort_reverse: +this._reverse,
            page: this._page
        }, function(result) {
            var pagesInfo = {
                current: result && +result.page,
                total: result && +result.pages_num
            };

            this._render(result && result.reports, pagesInfo);

            if (u.consts('isPostviewConversionsReportEnabled')) {
                this.trigger('update', { isCreatePostviewDisabled: result.isCreatePostviewDisabled });
            }
        },
            { callbackCtx: this });
    },

    /**
     * Шаблонизирует таблицу готовых отчетов
     * @param {Array} [reports]
     * @param {Object} [pagesInfo]
     * @private
     */
    _render: function(reports, pagesInfo) {
        var _this = this,
            content = BEMHTML.apply({
                block: 'b-statistic-reports-list',
                elem: 'content',
                reports: reports || [],
                ulogin: this.params.ulogin,
                lang: this.params.lang,
                url: this.params.url,
                sortBy: this._sortBy,
                reverse: this._reverse,
                currentPage: pagesInfo.current,
                totalPages: pagesInfo.total
            });

        BEM.DOM.update(this.elem('content-wrap'), content, function() {
            _this.delMod(_this.elem('loading'), 'show');

            _this.findBlocksOn(_this.findElem('sort'), 'link').forEach(function(sortLink) {
                sortLink.on('click', function(e) {
                    var sortBy = _this.getMod(e.block.domElem, 'key');

                    _this.sort(sortBy, sortBy === _this._sortBy ? !_this._reverse : true);
                });
            });
        });
    },

    /**
     * Сортирует таблицу готовых отчетов
     * @param {String} sortBy
     * @param {Boolean} reverse
     */
    sort: function(sortBy, reverse) {
        this._sortBy = sortBy;
        this._reverse = reverse;

        this.update();
    }

});
