/**
 * @param {String} [this.ctx.name] название условия нацеливания
 * @param {DynamicConditionGoal[]} [this.ctx.condition] правила условия нацеливания
 * Если параметры не переданы, будет отображена строка "Название недоступно (условие нацеливания)"
 */
block('b-statistics-dynamic-condition')(
    js()(function() {
        return {
            condition: this.ctx.condition
        };
    }),

    content()(function() {
        return [
            {
                elem: 'name',
                content: this.ctx.name || iget2('b-statistics-dynamic-condition', 'nazvanie-nedostupno', 'Название недоступно')
            },
            this.ctx.condition && {
                elem: 'switcher'
            }
        ];
    }),

    elem('switcher').content()({
        block: 'b-icon',
        mods: {
            'size-16': 'threedots'
        }
    })
);
