block('b-statistics-form').mod('type', 'brand_safety_mol')(

    def()(function() {
        var data = this.data,
            form = data.FORM,
            submitParams = {
                cmd: 'showCampStat',
                stat_type: 'brand_safety_mol',
                cid: data.cid,
                online_stat: 1,
                // для сквозного сохранения target_'ов для других вкладок
                target_all: form.target_all,
                target_0: form.target_0,
                target_1: form.target_1,
                stat_periods: data.USER_OPTIONS.stat_periods,
                ulogin: data.user_login,
                // блуждающий флаг перехода внутри статистики
                isStat: form.isStat ? 1 : undefined
            },
            fields = [
                apply('group'),
                apply('calendar'),
                apply('category'),
                apply('campaign')
            ];

        return {
            block: 'b-layout-form',
            mix: [
                {
                    block: 'b-statistics-form',
                    mods: this.mods,
                    js: {
                        submitParams: submitParams
                    }
                }
            ],
            mixes: {
                submit: {
                    block: 'b-statistics-form',
                    elem: 'submit-row'
                }
            },
            rows: fields.map(function(row) {
                return row ?
                    {
                        label: row.label && {
                            content: row.label
                        },
                        control: row.control,
                        mix: (row.mix || []).concat([{
                            block: 'b-statistics-form',
                            elem: 'row',
                            elemMods: row.mods
                        }])
                    } :
                    undefined;
            }),
            submit: [
                {
                    block: 'button',
                    mods: { theme: 'action' },
                    mix: [{
                        block: 'b-statistics-form',
                        elem: 'submit-button'
                    }],
                    content: iget2('b-statistics-form', 'pokazat-137', 'Показать')
                },
                apply('export-dropdown')
            ]
        };
    }),

    mode('group')(function() {
        var group = 'DAY';

        return {
            label: [
                iget2('b-statistics-form', 'gruppirovka', 'Группировка'),
            ],
            control: {
                block: 'select',
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'bs-group-select'
                }],
                name: 'group_by_date',
                content: [
                    {
                        block: 'button'
                    },
                    {
                        elem: 'control',
                        content: [
                            {
                                title: iget2('b-statistics-form', 'za-vybrannyy-period', 'за выбранный период'),
                                value: 'SELECTED_PERIOD'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-dnyam', 'по дням'),
                                value: 'DAY'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-nedelyam', 'по неделям'),
                                value: 'WEEK'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-mesyacam', 'по месяцам'),
                                value: 'MONTH'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-kvartalam', 'по кварталам'),
                                value: 'QUARTER'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-godam', 'по годам'),
                                value: 'YEAR'
                            }
                        ].map(function(item) {
                            return {
                                elem: 'option',
                                attrs: u._.extend({ value: item.value },
                                    item.value == group ? { selected: 'selected' } : {}),
                                content: item.title
                            };
                        })
                    }
                ]
            }
        };
    }),

    mode('category')(function() {
        return {
            label: [
                iget2('b-statistics-form', 'bs-category', 'Группировка по категории')
            ],
            control: {
                block: 'checkbox',
                mods: {
                    checked: 'yes'
                },
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'category-checkbox'
                }],
                checkboxAttrs: {
                    name: 'with_category',
                    id: 'with_category'
                }
            }
        };
    }),

    mode('campaign')(function() {
        return {
            label: [
                iget2('b-statistics-form', 'bs-campaign', 'Группировка по кампании')
            ],
            control: {
                block: 'checkbox',
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'campaign-checkbox'
                }],
                checkboxAttrs: {
                    name: 'with_campaign',
                    id: 'with_campaign'
                }
            }
        };
    }),

    mode('export-dropdown')(function() {
        return {
            block: 'button',
            mods: { pseudo: 'yes' },
            mix: [{
                block: 'b-statistics-form',
                elem: 'export-button'
            }],
            content: [
                {
                    block: 'image',
                    mods: {
                        type: 'export'
                    },
                    mix: {
                        block: 'button',
                        elem: 'icon'
                    },
                    alt: ''
                },
                iget2('b-statistics-form', 'eksport-xlsx', 'Экспорт XLSX')
            ]
        };
    })
);
