block('b-statistics-form').mod('type', 'campdate')(

    def()(function() {

        !this.data.group_hash && (this.data.group_hash = {});

        var data = this.data,
            form = data.FORM,
            submitParams = {
                cmd: 'showCampStat',
                stat_type: 'campdate',
                online_stat: 1,
                stat_periods: data.USER_OPTIONS.stat_periods,
                currency_archive: data.currency_archive,
                ulogin: data.user_login,
                show_favorites: form.show_favorites,
                cid: form.cid,
                // блуждающий флаг перехода внутри статистики
                isStat: form.isStat ? 1 : undefined,
                reverse: form.reverse
            },
            fields = [
                data.show_manager_filter && apply('manager_filter'),
                // Выбранный период должен начинаться не раньше 1 января 2000 года
                apply('calendar', {
                    'ctx.limits': {
                        earlier: '2000-01-01'
                    }
                }),
                apply('group'),
                apply('target'),
                data.had_nds && apply('nds')
            ];

        return {
            block: 'b-layout-form',
            mix: [
                {
                    block: 'b-statistics-form',
                    mods: this.mods,
                    js: {
                        submitParams: submitParams
                    }
                }
            ],
            mixes: {
                submit: {
                    block: 'b-statistics-form',
                    elem: 'submit-row'
                }
            },
            hiddenInputs: [
                form.sort && form.sort.toString && {
                    name: 'sort',
                    value: u.escapeHTML(form.sort.toString())
                },
                {
                    name: 'save_nds',
                    value: '1'
                }
            ],
            rows: fields.map(function(field) {
                return field ?
                    {
                        label: {
                            content: field.label
                        },
                        control: field.control,
                        mix: (field.mix || []).concat([{
                            block: 'b-statistics-form',
                            elem: 'row',
                            elemMods: field.mods
                        }])
                    } :
                    undefined;
            }),
            submit: [
                {
                    block: 'button',
                    mods: { theme: 'action' },
                    mix: [{
                        block: 'b-statistics-form',
                        elem: 'submit-button'
                    }],
                    content: iget2('b-statistics-form', 'pokazat-137', 'Показать')
                },
                applyCtx({
                    block: 'b-statistics-form',
                    elem: 'download',
                    content: {
                        elem: 'download-as-xls'
                    }
                })
            ]
        };
    }),

    mode('manager_filter')(function() {

        return {
            label: iget2('b-statistics-form', 'menedzher', 'Менеджер'),
            control: {
                block: 'radio-button',
                mix: {
                    block: 'b-statistics-form',
                    elem: 'manager-select'
                },
                name: 'show_for_manager',
                value: this.data.FORM.show_for_manager ? '1' : '',
                content: [
                    {
                        value: '1',
                        title: [iget2('b-statistics-form', 'vy', 'вы'), ' (', this.data.uname, ')']
                    },
                    {
                        value: '',
                        title: iget2('b-statistics-form', 'vse-138', 'все')
                    }
                ].map(function(item) {
                    return {
                        elem: 'radio',
                        controlAttrs: {
                            value: item.value
                        },
                        content: item.title
                    };
                })
            }
        };
    }),

    mode('group')(function() {
        var group = apply('group-data') || 'day';

        return {
            label: iget2('b-statistics-form', 'gruppirovat', 'Группировать'),
            mods: {
                advanced: this.ctx.statParamsShowAll ? '' : 'yes'
            },
            control: {
                block: 'select',
                name: 'group',
                content: [
                    {
                        block: 'button'
                    },
                    {
                        elem: 'control',
                        content: [
                            {
                                title: iget2('b-statistics-form', 'po-dnyam', 'по дням'),
                                value: 'day'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-nedelyam', 'по неделям'),
                                value: 'week'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-mesyacam', 'по месяцам'),
                                value: 'month'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-kvartalam', 'по кварталам'),
                                value: 'quarter'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-godam', 'по годам'),
                                value: 'year'
                            }
                        ].map(function(item) {
                            return {
                                elem: 'option',
                                attrs: u._.extend({ value: item.value },
                                    item.value == group ? { selected: 'selected' } : {}),
                                content: item.title
                            };
                        }, this)
                    }
                ]
            }
        };
    })
);
