block('b-statistics-form').mod('type', 'common').def()(function() {
    var data = this.data,
        form = data.FORM,
        showDefault = data.login_rights.role == 'support' ||
            form.goals && form.goals != '0' ||
            form.group && form.group != 'day' ||
            form.target_type && /^(search|context)$/.test(form.target_type) ||
            form.target_0 ||
            form.target_1 ||
            form.through_list ||
            form.with_nds,
        submitParams = {
            cmd: 'showCampStat',
            cid: data.cid,
            online_stat: 1,
            stat_periods: data.USER_OPTIONS.stat_periods,
            currency_archive: data.currency_archive
        },
        offlineStat = data.offline_stat || form.offline_stat,
        uidPar = data.uid_par,
        fields = [
            apply('calendar'),
            data.had_nds && apply('nds'),
            data.had_nds && apply('show-link'),
            u['b-statistics-form'].isNeedAttribution(data.campaign) && {
                mods: { advanced: this.ctx.statParamsShowAll ? '' : 'yes' },
                label: apply('attribution-label'),
                control: apply('attribution-display')
            },
            apply('detail-stat')
        ];

    offlineStat && (submitParams.offline_stat = offlineStat);
    uidPar && (submitParams[uidPar.key] = uidPar.value);

    form.detail && (submitParams.detail = 1);

    // блуждающий флаг перехода внутри статистики
    form.isStat && (submitParams.isStat = form.isStat);

    ['page', 'allpages', 'interface', 'target_type'].forEach(function(name) {
        form[name] && (submitParams[name] = form[name]);
    });

    showDefault || form.isStat && (showDefault = !!data.COOKIES['b-statistics-form_show-default_yes~cid:' + data.cid]);

    return {
        block: 'b-layout-form',
        mix: [{
            block: 'b-statistics-form',
            mods: {
                'show-default': showDefault ? 'yes' : 'no'
            },
            js: {
                submitParams: submitParams
            }
        }],
        mixes: {
            submit: {
                block: 'b-statistics-form',
                elem: 'submit-row'
            }
        },
        hiddenInputs: [{
            name: 'sort',
            value: form.sort && form.sort.toString()
        }, {
            name: 'save_nds',
            value: '1'
        }],
        rows: fields.map(function(row) {
            return row ?
                {
                    label: {
                        content: row.label
                    },
                    control: row.control,
                    mix: (row.mix || []).concat([{
                        block: 'b-statistics-form',
                        elem: 'row',
                        elemMods: row.mods
                    }])
                } :
                undefined;
        }),
        submit: [
            {
                block: 'button',
                mods: { theme: 'action' },
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'submit-button'
                }],
                content: iget2('b-statistics-form', 'pokazat-137', 'Показать')
            },
            applyCtx({
                block: 'b-statistics-form',
                elem: 'download',
                content: {
                    elem: 'download-as-xls'
                }
            })
        ]
    };
});
