block('b-statistics-form').mod('type', 'day')(

    def()(function() {
        var data = this.data,
            form = data.FORM,
            showDefault = data.login_rights.role == 'support' ||
            form.goals && form.goals != '0' ||
            form.group && form.group != 'day' ||
            form.target_type && /^(search|context)$/.test(form.target_type) ||
            form.target_0 ||
            form.target_1 ||
            form.through_list ||
            form.with_nds,
            submitParams = {
                cmd: 'showCampStat',
                cid: data.cid,
                online_stat: 1,
                stat_periods: data.USER_OPTIONS.stat_periods,
                // блуждающий флаг перехода внутри статистики
                isStat: form.isStat ? 1 : undefined,
                currency_archive: data.currency_archive
            },
            offlineStat = data.offline_stat || form.offline_stat,
            uidPar = data.uid_par,
            fields = [];

        offlineStat && (submitParams.offline_stat = offlineStat);
        uidPar && (submitParams[uidPar.key] = uidPar.value);

        form.detail && (submitParams.detail = 1);

        ['page', 'allpages', 'interface', 'target_type'].forEach(function(name) {
            form[name] && (submitParams[name] = form[name]);
        });

        fields.push(apply('calendar'), apply('group'));
        data.directya || fields.push(apply('goals'));
        u['b-statistics-form'].isNeedAttribution(data.campaign) &&
            fields.push(apply('attribution'));
        fields.push(apply('target'));
        data.had_nds && fields.push(apply('nds'));
        fields.push(apply('show-link'), apply('detail-stat'));

        showDefault ||
            form.isStat && (showDefault = !!data.COOKIES['b-statistics-form_show-default_yes~cid:' + data.cid]);

        return {
            block: 'b-layout-form',
            mix: [{
                block: 'b-statistics-form',
                mods: {
                    'show-default': showDefault ? 'yes' : 'no'
                },
                js: {
                    submitParams: submitParams
                }
            }],
            mixes: {
                submit: {
                    block: 'b-statistics-form',
                    elem: 'submit-row'
                }
            },
            hiddenInputs: [
                {
                    name: 'sort',
                    value: !!form.sort && typeof form.sort !== 'undefined' && form.sort.toString()
                },
                {
                    name: 'save_nds',
                    value: '1'
                },
                {
                    name: 'reverse',
                    value: !!form.reverse && typeof form.reverse !== 'undefined' && form.reverse.toString()
                }
            ],
            rows: fields.map(function(i) {
                return {
                    label: {
                        content: i.label
                    },
                    control: i.control,
                    mix: (i.mix || []).concat[{
                        block: 'b-statistics-form',
                        elem: 'row',
                        elemMods: i.mods
                    }]
                };
            }),
            submit: [{
                block: 'button',
                mods: { theme: 'action' },
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'submit-button'
                }],
                content: iget2('b-statistics-form', 'pokazat-137', 'Показать')
            }, applyCtx({
                block: 'b-statistics-form',
                elem: 'download',
                content: {
                    elem: 'download-as-xls'
                }
            })]
        };
    }),

    mode('calendar')(function() {
        var data = this.data,
            statPeriods = data.FORM.stat_periods || (data.USER_OPTIONS || {}).stat_periods,
            limits = {
                earlier: u['b-statistics-form'].getDateLimits().minDate.format('YYYY-MM-DD')
            },
            uniqueHash = {},
            historyRanges = [];

        statPeriods && statPeriods.split(',').forEach(function(i) {
            if (i && !uniqueHash[i]) {
                uniqueHash[i] = true;

                i = i.split(':');
                historyRanges.push({
                    start: i[0],
                    finish: i[1]
                });
            }
        });

        var period = apply('period-data');

        return {
            label: iget2('b-statistics-form', 'period', 'Период'),
            control: {
                block: 'b-date-range-picker',
                start: {
                    value: period.start,
                    limits: limits
                },
                finish: {
                    value: period.finish,
                    limits: limits
                },
                ranges: [
                    {
                        title: iget2('b-statistics-form', 'segodnya', 'сегодня'),
                        start: 0,
                        finish: 0
                    },
                    {
                        title: iget2('b-statistics-form', 'vchera', 'вчера'),
                        start: -1,
                        finish: -1
                    },
                    {
                        title: iget2('b-statistics-form', '7-dney', '7 дней'),
                        start: -7,
                        finish: 0
                    },
                    {
                        title: iget2('b-statistics-form', '30-dney', '30 дней'),
                        start: -30,
                        finish: 0
                    },
                    {
                        title: iget2('b-statistics-form', '90-dney', '90 дней'),
                        start: -90,
                        finish: 0
                    },
                    {
                        title: iget2('b-statistics-form', '365-dney', '365 дней'),
                        start: -365,
                        finish: 0
                    }
                ],
                history: statPeriods && {
                    title: iget2('b-statistics-form', 'istoriya', 'история'),
                    periods: historyRanges
                },
                dateFormat: 'YYYY-MM-DD',
                viewFormat: 'DD MMM YYYY',
                calendarMix: [{
                    block: 'b-statistics-form',
                    elem: 'date-range-picker-calendar'
                }],
                inputMods: {
                    adaptive: 'no'
                }
            }
        };
    }),

    mode('show-link')(function() {
        return {
            mods: {
                type: 'show-button'
            },
            control: {
                block: 'check-button',
                mods: { theme: 'pseudo' },
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'show-button'
                }],
                content: iget2('b-statistics-form', 'pokazat-dopolnitelnye-nastroyki', 'Показать дополнительные настройки')
            }
        };
    }),

    mode('group')(function() {
        var group = apply('group-data') || 'day';

        return {
            label: iget2('b-statistics-form', 'gruppirovat', 'Группировать'),
            mods: {
                advanced: this.ctx.statParamsShowAll ? '' : 'yes'
            },
            control: {
                block: 'select',
                name: 'group',
                content: [
                    {
                        block: 'button'
                    },
                    {
                        elem: 'control',
                        content: [
                            {
                                title: iget2('b-statistics-form', 'po-dnyam', 'по дням'),
                                value: 'day'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-nedelyam', 'по неделям'),
                                value: 'week'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-mesyacam', 'по месяцам'),
                                value: 'month'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-kvartalam', 'по кварталам'),
                                value: 'quarter'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-godam', 'по годам'),
                                value: 'year'
                            }
                        ].map(function(item) {
                            return {
                                elem: 'option',
                                attrs: u._.extend(
                                    { value: item.value },
                                    item.value == group ? { selected: 'selected' } : {}
                                ),
                                content: item.title
                            };
                        }, this)
                    }
                ]
            }
        };
    }),

    mode('target')(function() {
        var form = this.data.FORM,
            allDisabled = this.ctx.allDisabled,
            defaultChecked = !(form.target_all || form.target_0 || form.target_1);

        return {
            label: iget2('b-statistics-form', 'ploshchadki', 'Площадки'),
            mods: {
                type: 'target',
                advanced: this.ctx.statParamsShowAll ? '' : 'yes'
            },
            control: [
                {
                    title: iget2('b-statistics-form', 'vsego-103', 'всего'),
                    name: 'target_all',
                    defaultChecked: defaultChecked
                },
                {
                    title: iget2('b-statistics-form', 'poisk-134', 'поиск'),
                    name: 'target_0'
                },
                {
                    title: iget2('b-statistics-form', 'seti', 'сети'),
                    name: 'target_1'
                }
            ].map(function(item) {
                return {
                    block: 'checkbox',
                    mods: {
                        disabled: allDisabled ? 'yes' : '',
                        checked: item.defaultChecked || form[item.name] ? 'yes' : ''
                    },
                    checkboxAttrs: {
                        name: item.name,
                        id: item.name,
                        value: 1
                    },
                    text: item.title
                };
            })
        };
    }),

    mode('nds')(function() {
        return {
            label: [
                iget2('b-statistics-form', 'nds', 'НДС'),
                {
                    block: 'b-help-link',
                    mods: {
                        type: 'modal'
                    },
                    width: 1110,
                    stretched: true,
                    url: u.getHelpUrl('include-vat')
                }
            ],
            mods: {
                advanced: this.ctx.statParamsShowAll ? '' : 'yes'
            },
            control: {
                block: 'checkbox',
                mods: {
                    checked: apply('nds-data') ? 'yes' : ''
                },
                checkboxAttrs: {
                    name: 'with_nds',
                    id: 'with_nds',
                    value: 1
                },
                text: iget2('b-statistics-form', 'vklyuchen', 'включен')
            }
        };
    })
);
