block('b-statistics-form').mod('type', 'geo')(

    def()(function() {

        !this.data.group_hash && (this.data.group_hash = {});

        var data = this.data,
            form = data.FORM,
            showDefault = data.login_rights.role == 'support' ||
            form.goals && form.goals != '0' ||
            form.target_type && (form.target_type == 'search' || form.target_type == 'context') ||
            form.group && form.group != 'day' ||
            form.through_list ||
            form.target_0 ||
            form.target_1 ||
            form.with_nds,
            submitParams = {
                cmd: 'showCampStat',
                stat_type: form.stat_type,
                cid: data.cid,
                online_stat: 1,
                stat_periods: data.USER_OPTIONS.stat_periods,
                currency_archive: data.currency_archive,
                // блуждающий флаг перехода внутри статистики
                isStat: form.isStat ? 1 : undefined,
                ulogin: data.user_login
            },
            fields = [];

        fields.push(apply('calendar'));
        data.directya || fields.push(apply('goals'));
        !data.isCpmStat && fields.push(apply('target'));
        u['b-statistics-form'].isNeedAttribution(data.campaign) &&
            fields.push(apply('attribution'));
        data.had_nds && fields.push(apply('nds'));
        fields.push(apply('show-through'));
        fields.push(apply('show-link'));
        fields.push(apply('detail-stat'));

        showDefault ||
            form.isStat && (showDefault = !!data.COOKIES['b-statistics-form_show-default_yes~cid:' + data.cid]);

        return {
            block: 'b-layout-form',
            mix: [
                {
                    block: 'b-statistics-form',
                    mods: {
                        'show-default': showDefault ? 'yes' : 'no'
                    },
                    js: {
                        submitParams: submitParams
                    }
                }
            ],
            mixes: {
                submit: {
                    block: 'b-statistics-form',
                    elem: 'submit-row'
                }
            },
            hiddenInputs: [
                form.sort && {
                    name: 'sort',
                    value: form.sort.toString()
                },
                form.reverse && {
                    name: 'reverse',
                    value: form.reverse.toString()
                },
                data.had_nds && {
                    name: 'save_nds',
                    value: '1'
                }
            ],
            rows: fields.map(function(i) {
                return {
                    label: i.label && {
                        content: i.label
                    },
                    control: i.control,
                    mix: (i.mix || []).concat([{
                        block: 'b-statistics-form',
                        elem: 'row',
                        elemMods: i.mods
                    }])
                };
            }),
            submit: [
                {
                    block: 'button',
                    mods: { theme: 'action' },
                    mix: [{
                        block: 'b-statistics-form',
                        elem: 'submit-button'
                    }],
                    content: iget2('b-statistics-form', 'pokazat-137', 'Показать')
                },
                applyCtx({
                    block: 'b-statistics-form',
                    elem: 'download',
                    content: {
                        elem: 'download-as-xls'
                    }
                })
            ]
        };
    }),

    mode('show-through')(function() {
        return {
            mods: {
                advanced: this.ctx.statParamsShowAll ? '' : 'yes'
            },
            control: {
                block: 'checkbox',
                mods: {
                    checked: this.data.FORM.through_list ? 'yes' : ''
                },
                checkboxAttrs: {
                    name: 'through_list',
                    value: '1'
                },
                text: iget2('b-statistics-form', 'otobrazhat-v-vide-skvoznogo', 'Отображать в виде сквозного списка')
            }
        };
    })
);
