block('b-statistics-form').match(function() {
    return !!~['moc', 'mol'].indexOf(this.mods.type);
})(

    def()(function() {
        var data = this.data,
            operatorFeatures = data.features_enabled_for_operator_all,
            controlClients = data.mcc && data.mcc.clients || [],
            mccEnabled = operatorFeatures && operatorFeatures.includes('CLIENT_MCC') && controlClients.length > 0,
            filters = data.filters || {},
            currentReport = {},
            statReportMaster = {
                stat_master_reports: data.stat_reports
            } || {},
            sortParams = {},
            xlsRowsLimitExceeded = data.xls_rows_limit_exceeded,
            tooMuchStatisticsError = data.too_much_statistics_error,
            xlsLimits,
            // для ДРФ мы не даем включать сравнение!
            disableCompare = data.statType == 'ext_phrases' || data.statType == 'search_queries',
            decl = applyCtx({
                block: 'i-mo-decl',
                mods: {
                    type: u.beminize(data.statType)
                }
            }),
            campaign = this.data.campaign || {},
            availableFilters = decl.filters.map(function(f) {
                return typeof f == 'string' ? f : f.name;
            }),
            allowedInternals = u.consts('rights').enableInternalCampaigns && (
                campaign.type ?
                    u.campaign.isInternal(campaign.type) :
                    u.campaign.hasInternal(data.available_camp_types)
            );

        this.campType = campaign.type;

        if (data.FORM.sort) {
            sortParams.sort = data.FORM.sort;
        }

        if (data.FORM.reverse) {
            sortParams.reverse = data.FORM.reverse;
        }

        if (xlsRowsLimitExceeded) {
            xlsLimits = {
                format: data.FORM.format,
                count: xlsRowsLimitExceeded.rows_num,
                limit: xlsRowsLimitExceeded.rows_limit
            };
        }

        // обратная совместимость для фильтра по цели (DIRECT-89076)
        if (filters.goal_id) {
            data.FORM.goals = filters.goal_id.eq;
        }

        // Если нет фильтра по кампаниям
        // но есть список кампаний в FORM.cid
        // создаем фильтр заполняя его этим списком
        if (!filters.campaign && data.FORM.cid) {
            var cidsForFilter = data.FORM.cid.replace(/\s/g, '').split(',').filter(function(cid) {
                return u._.findIndex(data.campaigns_list, function(camp) {
                    return camp.cid == cid;
                }) !== -1;
            });

            if (cidsForFilter.length) {
                filters.campaign = {
                    eq: cidsForFilter
                };
            }
        }

        (statReportMaster.stat_master_reports || []).forEach(function(item) {
            if (item.report_id == data.report_id) {
                currentReport = item;
            }
        }, this);
        return {
            block: 'b-layout-form',
            mix: [{
                block: 'b-statistics-form',
                mods: {
                    type: 'mol',
                    'disable-compare': disableCompare ? 'yes' : undefined,
                    compare: data.compare_periods ? 'yes' : undefined,
                    unexpanded: data.FORM.show_stat && !tooMuchStatisticsError ? 'yes' : undefined
                },
                js: {
                    sortParams: sortParams,
                    xlsLimits: xlsLimits,
                    comparePeriods: data.compare_periods,
                    tooMuchStatisticsError: tooMuchStatisticsError,
                    cid: data.campaign && data.FORM.cid,
                    statType: data.statType,
                    singleCamp: data.campaign && data.FORM.single_camp,
                    reportId: data.report_id
                }
            }],
            rows: u._.compact([
                apply('report-title'),
                mccEnabled && apply('clients'),
                apply('group-and-compare'),
                allowedInternals && apply('group-by-region-level'),
                !data.directya && ['mol', 'moc'].includes(data.statType) && apply('goals'),
                u['b-statistics-form'].isNeedAttribution(data.campaign) &&
                    apply('attribution'),
                apply('periods-picker', {
                    dateParams: {
                        range: currentReport.date_range,
                        shift: currentReport.date_shift
                    }
                }),
                apply('nds-page-size'),
                apply('expander'),
                apply('columns-slices', {
                    columnsSlices: {
                        columns: decl.columns,
                        slices: decl.slices
                    }
                }),
                apply('filters-editor', {
                    filters: filters,
                    availableFilters: availableFilters
                })
            ]).map(function(i) {
                return {
                    label: {
                        content: i.label
                    },
                    control: i.control,
                    mix: [{
                        block: 'b-statistics-form',
                        elem: 'row',
                        elemMods: i.mods
                    }]
                };
            }),
            submit: [
                {
                    block: 'button',
                    mods: { theme: 'action' },
                    mix: [{
                        block: 'b-statistics-form',
                        elem: 'submit-button'
                    }],
                    content: iget2('b-statistics-form', 'pokazat-137', 'Показать')
                },
                apply('export-dropdown'),
                allowedInternals && apply('with-resources-checkbox'),
                {
                    block: 'b-statistics-template-saving',
                    mix: [{
                        block: 'b-statistics-form',
                        elem: 'dropdown-report-button'
                    }],
                    switcher: {
                        text: iget2('b-statistics-form', 'sohranit-otchet', 'Сохранить отчет')
                    },
                    input: {
                        value: currentReport.report_name || '',
                        hint: iget2('b-statistics-form', 'nazvanie-otcheta', 'название отчета')
                    }
                }
            ]
        };
    }),

    mode('report-title')(function() {
        var statReportMaster = {
            stat_master_reports: this.data.stat_reports
        } || {};

        return {
            control: [
                {
                    block: 'b-page-title',
                    mix: [{
                        block: 'b-statistics-form',
                        elem: 'report-title'
                    }],
                    title: {
                        block: 'b-statistics-template-list',
                        mix: [{
                            block: 'b-statistics-form',
                            elem: 'template-list'
                        }],
                        defaultTitle: iget2('b-statistics-form', 'novyy-otchet', 'Новый отчет'),
                        resetTitle: iget2('b-statistics-form', 'novyy-otchet', 'Новый отчет'),
                        templates: (statReportMaster.stat_master_reports || []).map(function(item) {
                            return {
                                params: item,
                                title: item.report_name,
                                selected: item.report_id == this.data.report_id,
                                content: [
                                    u.escapeHTML(u.hellipCut(item.report_name, 35, '...')),
                                    item.compare_periods && {
                                        block: 'b-icon',
                                        mods: {
                                            'size-13': 'compare-periods'
                                        },
                                        mix: {
                                            block: 'b-statistic-filters-editor',
                                            elem: 'compare-periods-icon'
                                        }
                                    }
                                ]
                            };
                        }, this)
                    }
                }
            ]
        };
    }),

    mode('group-and-compare')(function() {
        return {
            mods: {
                type: 'compare'
            },
            control: [
                {
                    block: 'b-statistics-form',
                    elem: 'period-group',
                    content: apply('group')
                },
                {
                    block: 'check-button',
                    mods: {
                        theme: 'pseudo',
                        checked: this.data.compare_periods ? 'yes' : undefined,
                        disabled: (this.data.goal_ids || []).length > 1 ? 'yes' : ''
                    },
                    mix: {
                        block: 'b-statistics-form',
                        elem: 'compare-toggler'
                    },
                    controlAttrs: {
                        autocomplete: 'off'
                    },
                    content: [
                        {
                            block: 'b-icon',
                            mods: {
                                'size-16': 'compare-periods'
                            },
                            mix: [
                                {
                                    block: 'check-button',
                                    elem: 'icon'
                                },
                                {
                                    block: 'b-statistics-form',
                                    elem: 'compare-periods-icon'
                                }
                            ]
                        },
                        {
                            block: 'b-statistics-form',
                            elem: 'compare-toggler-text',
                            elemMods: { type: 'on' },
                            content: iget2('b-statistics-form', 'otmenit-sravnenie', 'Отменить сравнение')
                        },
                        {
                            block: 'b-statistics-form',
                            elem: 'compare-toggler-text',
                            elemMods: { type: 'off' },
                            content: iget2('b-statistics-form', 'sravnit-periody', 'Сравнить периоды')
                        }
                    ]
                }
            ]
        };
    }),

    mode('periods-picker')(function() {
        var data = this.data,
            calendarA,
            calendarB,
            dateRangeB,
            dateShiftB;

        // dateParams используется для сохранения относительной даты в шаблоне
        // range - количество дней между date_from и date_to
        // shift - количество дней относительно текущей даты и date_to

        var period = (data.report_id && {
            start: data.date_from,
            finish: data.date_to
        }) || apply('period-data');

        calendarA = {
            mix: [{
                block: 'b-statistics-form',
                elem: 'range-picker',
                elemMods: { type: 'a' }
            }],
            id: 'a-calendar',
            start: period.start,
            finish: period.finish,
            dateRange: this.dateParams.range,
            dateShift: this.dateParams.shift,
            ranges: u._.filter([
                {
                    title: iget2('b-statistics-form', 'segodnya', 'сегодня'),
                    start: 0,
                    finish: 0
                },
                {
                    title: iget2('b-statistics-form', 'vchera', 'вчера'),
                    start: -1,
                    finish: -1
                },
                {
                    title: iget2('b-statistics-form', '7-dney', '7 дней'),
                    start: -7,
                    finish: 0
                },
                {
                    title: iget2('b-statistics-form', '30-dney', '30 дней'),
                    start: -30,
                    finish: 0
                },
                {
                    title: iget2('b-statistics-form', '90-dney', '90 дней'),
                    start: -90,
                    finish: 0
                },
                // для статистики по поисковым запросам мы отключаем 365 дней
                // https://st.yandex-team.ru/DIRECT-66682 и включаем 180
                // Баг: https://st.yandex-team.ru/DIRECT-66682#1495796284000
                // если написать -180 дней, то в b-date-range-picker шаблон будет рассчитываться
                // как -179 дней.
                data.statType == 'search_queries' ?
                    {
                        title: iget2('b-statistics-form', '180-dney', '180 дней'),
                        start: -179,
                        finish: 0
                    } :
                    {
                        title: iget2('b-statistics-form', '365-dney', '365 дней'),
                        start: -365,
                        finish: 0
                    }
            ])
        };

        // вычисляем range и shift для периода B
        if (typeof this.dateParams.range == 'number') {
            dateRangeB = u['b-date-range-picker'].getDiff(data.date_to_b, data.date_from_b, 'days');
            dateShiftB = u['b-date-range-picker'].getDiff(data.date_to, data.date_to_b, 'days');
            dateShiftB += this.dateParams.shift || 0;
        }

        calendarB = {
            mix: [{
                block: 'b-statistics-form',
                elem: 'range-picker',
                elemMods: { type: 'b' }
            }],
            id: 'b-calendar',
            start: data.date_from_b,
            finish: data.date_to_b,
            dateRange: dateRangeB,
            dateShift: dateShiftB,
            ranges: [
                {
                    title: iget2('b-statistics-form', 'predydushchiy-period', 'предыдущий период'),
                    name: 'previous-period',
                    start: {
                        period: -1
                    },
                    finish: {
                        period: -1
                    },
                    dependId: 'a-calendar'
                },
                {
                    title: iget2('b-statistics-form', 'predydushchiy-god', 'предыдущий год'),
                    start: {
                        year: -1
                    },
                    finish: {
                        year: -1
                    },
                    dependId: 'a-calendar'
                }
            ]
        };

        return {
            control: [
                {
                    block: 'b-statistics-form',
                    elem: 'period',
                    elemMods: { type: 'a' },
                    content: [
                        {
                            block: 'b-statistics-form',
                            elem: 'period-title',
                            content: iget2('b-statistics-form', 'period-a-139', 'Период A')
                        },
                        apply('calendar', {
                            calendar: calendarA
                        })
                    ]
                },
                {
                    block: 'b-statistics-form',
                    elem: 'period',
                    elemMods: { type: 'b' },
                    content: [
                        {
                            block: 'b-statistics-form',
                            elem: 'period-title',
                            content: iget2('b-statistics-form', 'period-b', 'Период B')
                        },
                        apply('calendar', {
                            calendar: calendarB
                        })
                    ]
                }
            ]
        };
    }),

    mode('calendar')(function() {
        var data = this.data,
            calendar = this.calendar,
            statPeriods = data.FORM.stat_periods || (data.USER_OPTIONS || {}).stat_periods,
            historyRanges = [];

        statPeriods && statPeriods.split(',').forEach(function(i) {
            if (i) {
                i = i.split(':');
                historyRanges.push({
                    start: i[0],
                    finish: i[1]
                });
            }
        });

        return {
            block: 'b-date-range-picker',
            mix: calendar.mix,
            mods: {
                type: 'super'
            },
            id: calendar.id,
            minDate: u['b-statistics-form'].getDateLimits(this.data.statType || 'mo').minDate.format('YYYY-MM-DD'),
            start: calendar.start,
            finish: calendar.finish,
            dateRange: calendar.dateRange,
            dateShift: calendar.dateShift,
            ranges: calendar.ranges,
            center: calendar.center,
            history: statPeriods && {
                title: iget2('b-statistics-form', 'istoriya', 'история'),
                periods: historyRanges
            }
        };
    }),

    mode('group')(function() {
        var group = (this.report_id && this.data.group_by_date) || apply('group-data') || 'day';

        return [
            iget2('b-statistics-form', 'gruppirovka', 'Группировка'),
            {
                block: 'select',
                mods: {
                    disabled: this.data.compare_periods ? 'yes' : undefined
                },
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'period-group-select'
                }],
                name: 'group_by_date',
                content: [
                    {
                        block: 'button'
                    },
                    {
                        elem: 'control',
                        content: [
                            {
                                title: iget2('b-statistics-form', 'za-vybrannyy-period', 'за выбранный период'),
                                value: 'none'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-dnyam', 'по дням'),
                                value: 'day'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-nedelyam', 'по неделям'),
                                value: 'week'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-mesyacam', 'по месяцам'),
                                value: 'month'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-kvartalam', 'по кварталам'),
                                value: 'quarter'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-godam', 'по годам'),
                                value: 'year'
                            }
                        ].map(function(item) {
                            return {
                                elem: 'option',
                                attrs: u._.extend({ value: item.value },
                                    item.value == group ? { selected: 'selected' } : {}),
                                content: item.title
                            };
                        })
                    }
                ]
            }
        ];
    }),

    mode('group-by-region-level')(function() {
        var group = this.data.region_level;

        return {
            control: {
                block: 'b-statistics-form',
                elem: 'group-by-region-level',
                content: [
                    iget2('b-statistics-form', 'group-by-region', 'Группировка по региону'),
                    {
                        block: 'select',
                        mix: [{
                            block: 'b-statistics-form',
                            elem: 'region-level-select'
                        }],
                        name: 'region_level',
                        content: [
                            {
                                block: 'button'
                            },
                            {
                                elem: 'control',
                                content: [
                                    {
                                        title: '&mdash;',
                                        value: ''
                                    },
                                    {
                                        title: iget2('b-statistics-form', 'country', 'Страна'),
                                        value: 'country'
                                    },
                                    {
                                        title: iget2('b-statistics-form', 'district', 'Федеральный округ'),
                                        value: 'district'
                                    },
                                    {
                                        title: iget2('b-statistics-form', 'area', 'Субъект федерации'),
                                        value: 'area'
                                    },
                                    {
                                        title: iget2('b-statistics-form', 'city', 'Город'),
                                        value: 'city'
                                    },
                                    {
                                        title: iget2('b-statistics-form', 'detailed', 'С максимальной детализацией'),
                                        value: 'original'
                                    }
                                ].map(function(item) {
                                    return {
                                        elem: 'option',
                                        attrs: u._.extend({ value: item.value },
                                            item.value === group ? { selected: 'selected' } : {}),
                                        content: item.title
                                    };
                                })
                            }
                        ]
                    }
                ]
            }
        };
    }),

    mode('nds-page-size')(function() {
        return {
            control: [
                !!this.data.had_nds && {
                    block: 'b-statistics-form',
                    elem: 'control-item',
                    content: apply('nds')
                },
                {
                    block: 'b-statistics-form',
                    elem: 'control-item',
                    content: apply('page-size')
                }
            ]
        };
    }),

    mode('nds')(function() {
        return [
            {
                block: 'checkbox',
                mods: {
                    checked: (this.report_id && this.data.with_nds) || apply('nds-data') ? 'yes' : ''
                },
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'nds-checkbox'
                }],
                checkboxAttrs: {
                    name: 'with_nds',
                    id: 'with_nds',
                    value: 1
                },
                text: iget2('b-statistics-form', 'c-uchyotom-nds', 'c учётом НДС')
            },
            {
                block: 'b-help-link',
                mods: {
                    type: 'modal'
                },
                width: 1110,
                stretched: true,
                url: u.getHelpUrl('include-vat')
            }
        ];
    }),

    mode('with-resources-checkbox')(function() {
        return [
            {
                block: 'checkbox',
                mods: {
                    checked: apply('with-resources') ? 'yes' : ''
                },
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'resources-checkbox'
                }],
                checkboxAttrs: {
                    name: 'with_resources',
                    id: 'with_resources',
                    value: 1
                },
                text: iget2('b-statistics-form', 'with-resources', 'c ресурсами')
            }
        ];
    }),

    mode('page-size')(function() {
        var sizes = this.data.statType === 'search_queries' ? [10, 100, 1000] : [10, 100, 1000, 10000],
            pageSize = Number(this.data.page_size) || 100;

        return [
            iget2('b-statistics-form', 'strok-na-stranice', 'Строк на странице'),
            {
                block: 'select',
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'page-size-select'
                }],
                name: 'page_size',
                content: [
                    {
                        block: 'button'
                    },
                    {
                        elem: 'control',
                        content: sizes.map(function(size) {
                            return {
                                elem: 'option',
                                attrs: u._.extend({ value: size }, size === pageSize ? { selected: 'selected' } : {}),
                                content: size
                            };
                        }, this)
                    }
                ]
            }
        ];
    }),

    mode('expander')(function() {
        return {
            control: applyCtx({
                block: 'link',
                mods: {
                    pseudo: 'yes'
                },
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'expander'
                }],
                content: iget2('b-statistics-form', 'text-vybrannye-srezy-stolbcy', '{text} выбранные срезы, столбцы и фильтры', {
                    text: [
                        {
                            block: 'b-statistics-form',
                            elem: 'expander-show',
                            tag: 'span',
                            content: iget2('b-statistics-form', 'skryt-140', 'Скрыть')
                        },
                        {
                            block: 'b-statistics-form',
                            elem: 'expander-hide',
                            tag: 'span',
                            content: iget2('b-statistics-form', 'pokazat-137', 'Показать')
                        }
                    ]
                })
            })
        };
    }),

    mode('columns-slices')(function() {
        return {
            mods: {
                style: 'full-width',
                expandable: 'yes'
            },
            control: applyCtx({
                block: 'b-statistic-columns-slices',
                columns: this.columnsSlices.columns,
                slices: this.columnsSlices.slices,
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'columns-slices'
                }]
            })
        };
    }),

    mode('filters-editor')(function() {
        return {
            mods: {
                type: 'filters-editor',
                expandable: 'yes'
            },
            control: applyCtx({
                block: 'b-statistic-filters-editor',
                mods: {
                    compare: this.data.compare_periods ? 'yes' : undefined
                },
                filters: u['b-statistic-filters-editor'].fromServer(this.filters),
                availableFilters: this.availableFilters,
                templates: (this.data.stat_filters_sets || []).map(function(templateSet) {
                    var set = u._.extend({}, templateSet);

                    set.data = u['b-statistic-filters-editor'].fromServer(templateSet.data);
                    set.hasCompare = u['b-statistic-filters-editor'].isCompareTemplate(set.data);

                    return set;
                }),
                goalsList: this.data.goals_list || []
            })
        };
    }),

    mode('export-dropdown')(function() {
        return {
            block: 'dropdown',
            mix: {
                block: 'b-statistics-form',
                elem: 'export-dropdown'
            },
            content: [
                {
                    block: 'button',
                    mods: {
                        pseudo: 'yes'
                    },
                    mix: [
                        {
                            block: 'dropdown',
                            elem: 'switcher'
                        },
                        {
                            block: 'b-statistics-form',
                            elem: 'export-button'
                        }
                    ],
                    content: [
                        {
                            block: 'image',
                            mods: {
                                type: 'export'
                            },
                            mix: {
                                block: 'button',
                                elem: 'icon'
                            },
                            alt: ''
                        },
                        iget2('b-statistics-form', 'eksport', 'Экспорт')
                    ]
                },
                {
                    elem: 'popup',
                    mix: [{
                        block: 'b-statistics-form',
                        elem: 'export-popup'
                    }],
                    elemMods: { animate: 'no' },
                    js: {
                        tail: {
                            offset: 3
                        }
                    },
                    content: [
                        {
                            text: iget2('b-statistics-form', 'xls-fayl', 'XLS-файл'),
                            type: 'xls'
                        },
                        {
                            text: iget2('b-statistics-form', 'xlsx-fayl', 'XLSX-файл'),
                            type: 'xlsx'
                        },
                        {
                            text: iget2('b-statistics-form', 'csv-fayl', 'CSV-файл'),
                            type: 'csv'
                        }
                    ].map(function(item) {
                        return {
                            block: 'b-statistics-form',
                            elem: 'export-link',
                            elemMods: { type: item.type },
                            content: item.text
                        };
                    })
                }
            ]
        };
    }),

    mode('attribution')(function() {
        return {
            label: '',
            control: {
                block: this.block,
                elem: 'attribution',
                content: [
                    apply('attribution-label'),
                    apply('attribution-control')
                ]
            }
        }
    }),

    mode('goals')(function() {
        return {
            label: '',
            control: [
                apply('multi-goals-label'),
                apply('multi-goals-control')
            ]
        }
    }),

    mode('clients')(function() {
        return {
            label: '',
            control: [
                apply('multi-clients-label'),
                apply('multi-clients-control')
            ]
        }
    })
);
