BEM.DOM.decl({ block: 'b-statistics-form', modName: 'type', modVal: 'mol' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            var params = this.params;

            this._initEvents();
            this._filtersCheckExclusion();

            params.xlsLimits && this._xlsLimitsConfirm(params.xlsLimits);
            params.tooMuchStatisticsError && this._tooMuchStatisticsErrorAlert();

            this._currentTemplate = {
                name: (this._templatelist.getSelected() || {}).name,
                submitParams: this._getSubmitParams()
            };
        }
    },

    _currentTemplate: null,

    /**
     * Показывает сообщение, что невозможно выгрузить статистику
     * @param {Array} items - пункты
     * @param {String} title
     * @private
     */
    _tooMuchStatisticsErrorAlert: function(items, title) {
        if (!items) {
            items = [
                iget2(
                    'b-statistics-form',
                    'izmenit-gruppirovku-za-period',
                    'Изменить группировку за период. Например, вместо группировки «по дням» используйте «по месяцам»'
                ),
                iget2('b-statistics-form', 'udalit-odin-ili-neskolko', 'Удалить один или несколько срезов из отчета')
            ]
        }

        BEM.blocks['b-confirm'].open({
            title: title || [
                iget2('b-statistics-form', 'prevysheno-dopustimoe-kolichestvo-strok', 'Превышено допустимое количество строк в отчете.'),
                iget2('b-statistics-form', 'pozhaluysta-poprobuyte', 'Пожалуйста, попробуйте:')
            ].join('<br>'),
            message: items.map(function(item, index) {
                return (index + 1) + '.&nbsp' + item;
            }),
            type: 'alert'
        });
    },

    _xlsLimitsConfirm: function(xlsData) {
        BEM.blocks['b-confirm'].open({
            message: iget2(
                'b-statistics-form',
                'kolichestvo-strok-v-otchete',
                'Количество строк в отчете превышает {limit}. В файл будут выгружены только первые {limit} строк. Продолжить?',
                {
                    limit: u.numberFormatter.format(xlsData.limit, { precision: 0 })
                }
            ),
            textYes: iget2('b-statistics-form', 'ok', 'ОК'),
            textNo: iget2('b-statistics-form', 'otmena', 'Отмена'),
            onYes: function() {
                this._prepareSubmit({ format: xlsData.format, force_xls_rows_limit: 1 });
            }
        }, this);
    },

    _currentReport: null,

    _filtersCheckExclusion: function() {
        var columnsSlices = this._columnsSlices.getValue();

        this._filtersEditor
            .checkExclusion(columnsSlices.columns, columnsSlices.group_by);

        if (this._resourcesCheckbox) {
            var withResourcesCheckbox = columnsSlices.group_by.indexOf('banner') !== -1;

            this._resourcesCheckbox.toggleMod('disabled', 'yes', '', !withResourcesCheckbox);
        }
    },

    /**
     * Находит блоки, подписывается на события
     * @returns {*}
     * @private
     */
    _initEvents: function() {
        u.graspSelf.call(this, {
            _compareCheckButton: 'check-button inside compare-toggler',
            _templatelist: 'b-statistics-template-list inside template-list',
            _columnsSlices: 'b-statistic-columns-slices inside columns-slices',
            _templateSaving: 'b-statistics-template-saving inside dropdown-report-button',
            _filtersEditor: 'b-statistic-filters-editor inside',
            _regionLevelSelect: '? select on region-level-select',
            _resourcesCheckbox: '? checkbox on resources-checkbox',
            _periodGroupSelect: 'select on period-group-select',
            _attributionModel: '? select on attribution-control'
        });

        this._goalsSelector = this.findBlockOn('goals-select', 'goals-selector');
        this._submitButton = this.findBlockOn('submit-button', 'button');

        if (this._attributionModel) {
            this._attributionModel.on('change', function() {
                var val = this._attributionModel.val();

                this._columnsSlices.setExternalVals([val]);
                this._filtersEditor.setExternalVals([val]);
            }, this);
        }

        this.findBlockOn('expander', 'link')
            .on('click', $.debounce(this._slideToggle, 350, this));

        this._templateSaving
            .on('save', this._onTemplateSaving, this);

        this._columnsSlices
            .on('change', this._filtersCheckExclusion, this);

        this._filtersEditor
            .on('change remove fill', function(e, data) {
                if (this._filtersEditor.isValid()) {
                    this._templateSaving.enableButton('switcher');
                    this._submitButton.delMod('disabled');
                } else {
                    this._templateSaving.disableButton('switcher');
                    this._submitButton.setMod('disabled', 'yes');
                }

                if (e.type === 'fill') {
                    data.isResetTemplate || this._toggleCompare(data.needCompare, true);
                }
            }, this);

        this._templatelist
            .on('select', this._onTemplateSelect, this)
            .on('removing', this._onTemplateRemovingItem, this);

        this.bindTo('export-link', 'click', function(e) {
            this._prepareSubmit({ format: this.getMod(e.data.domElem, 'type') });
        });

        if (this._goalsSelector) {
            this._goalsSelector.on('change', this._onMultiGoalsSelectorChange, this);

            if (this._goalsSelector.hasMod('initial-empty', 'yes')) {
                this._goalsSelector.onFirst('change', this._onEmptyGoalsSelectorChange, this);
            }
        }

        return this;
    },

    isTemplateChanged: function() {
        return this._currentTemplate && !u._.isEqual(this._currentTemplate.submitParams, this._getSubmitParams());
    },

    /**
     * Перезагружает страницу, чтобы показать выбранный отчет
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onTemplateSelect: function(e, data) {
        if (this._notApplyTemplate) {
            this._notApplyTemplate = false;

            return false;
        }

        if (this.isTemplateChanged()) {
            BEM.blocks['b-confirm'].open({
                message: iget2('b-statistics-form', 'nastroyki-otcheta-ne-budut', 'Настройки отчета не будут сохранены. Продолжить?'),
                textYes: iget2('b-statistics-form', 'ok', 'ОК'),
                textNo: iget2('b-statistics-form', 'otmena', 'Отмена'),
                onYes: function() {
                    this._applyTemplate(data);
                },
                onNo: function() {
                    this._notApplyTemplate = true;

                    this._templatelist
                        .select(this._currentTemplate.name);
                }
            }, this);
        } else {
            this._applyTemplate(data);
        }
    },

    _notApplyTemplate: false,

    _applyTemplate: function(data) {
        var multiClientsModeEnabled = u.consts('rights').enableStatsMultiClientsMode,
            cid = this.params.cid,
            reportId = data.params.report_id,
            singleCamp = this.params.singleCamp,
            submitParams = {
                cmd: 'showStat',
                stat_type: this.params.statType
            };

        multiClientsModeEnabled && (submitParams.multi_clients_mode = 1);
        !multiClientsModeEnabled && (submitParams.ulogin = u.consts('ulogin'));

        reportId && (submitParams.report_id = reportId);
        cid && (submitParams.cid = cid);
        singleCamp && (submitParams.single_camp = singleCamp);

        BEM.create({ block: 'i-request', mods: { type: 'form' } })
            .submit(submitParams, {
                url: '/registered/main.pl',
                type: 'get'
            });
    },

    /**
     * Удаляет шаблон
     * @param {Event} e
     * @param {Object} template
     * @private
     */
    _onTemplateRemovingItem: function(e, template) {
        this._request({
            cmd: 'deleteStatReport',
            report_id: template.params.report_id
        }).then(function() {
            this._templatelist.remove(template.name);
        }, function() {
            this._templatelist.onError({ type: 'remove' });
        });
    },

    /**
     * Показывает b-confirm если уже есть шаблон с таким названием
     * @param {String} templateName - название шаблона
     * @param {String} reportId - id шаблона
     * @private
     */
    _resaveConfirm: function(templateName, reportId) {
        BEM.blocks['b-confirm'].open({
            message: BEMHTML.apply({
                block: 'b-statistics-form',
                elem: 'confirm-resave',
                content: iget2(
                    'b-statistics-form',
                    'u-vas-uzhe-est-141',
                    'У вас уже есть отчет с таким названием. При сохранении нового отчета существующий будет удален.'
                )
            }),
            textYes: iget2('b-statistics-form', 'ok', 'ОК'),
            textNo: iget2('b-statistics-form', 'otmena', 'Отмена'),
            fromPopup: this._templateSaving.getPopup(),
            onYes: function() {
                this.saveReportTemplate(templateName, reportId);
            },
            onNo: function() {
                // afterCurrentEvent что бы выставить фокус на инпут, иначе он вернется на кнопку
                this.afterCurrentEvent(function() {
                    this._templateSaving.getInput().setMod('focused', 'yes');
                });
            }
        }, this);
    },

    /**
     * Запрос на сохранение нового шаблона
     * @param {String} templateName - название шаблона
     * @param {String} [reportId] - id шаблона
     * @returns {BEM}
     */
    saveReportTemplate: function(templateName, reportId) {
        var orderParams = this._getSubmitParams(true, { winrate: true });

        if (reportId) {
            orderParams.report_id = reportId;
        }

        this._templateSaving.disableButton('save');

        this._request(
            $.extend({ cmd: 'saveStatReport', report_name: templateName }, orderParams))
            .then(function(data) {
                orderParams.report_id = data.report_id;

                this._onSuccessReportSave(templateName, orderParams);
            }, function(error) {
                if (typeof error == 'string') {
                    this._templateSaving
                        .showError(error);
                } else {
                    this._templateSaving
                        .showError(iget2(
                        'b-statistics-form',
                        'proizoshla-neizvestnaya-oshibka-poprobuyte-127',
                        'Произошла неизвестная ошибка. Попробуйте перегрузить страницу или обратитесь к сервису позже. Извините за доставленное неудобство.'
                    ))
                        .enableButton('save');
                }
            });
    },

    /**
     * Сохраняет новый шаблон
     * @param {Event} e
     * @param {String} templateName - название шаблона
     * @returns {*}
     * @private
     */
    _onTemplateSaving: function(e, templateName) {
        var foundTemplate = this._templatelist.findTemplate(templateName);

        foundTemplate ?
            this._resaveConfirm(templateName, foundTemplate.params.report_id) :
            this.saveReportTemplate(templateName);

        return this;
    },

    /**
     * Показываем b-confirm при успешном сохранении отчета
     * @param {String} templateName
     * @private
     */
    _successReportSaveConfirm: function(templateName) {
        BEM.blocks['b-confirm'].open({
            message: iget2('b-statistics-form', 'otchet-s-sohranen', 'Отчет "{foo}" сохранен', {
                foo: u.escapeHTML(templateName)
            }),
            type: 'alert'
        });
    },

    /**
     * Скрывает popup, ошибки. Добавляет сохраненный шаблон в конец списка шаблонов
     * @param {String} templateName - название шаблона
     * @param {Object} orderParams - параметры отчета
     * @private
     */
    _onSuccessReportSave: function(templateName, orderParams) {
        this._templateSaving
            .hidePopup()
            .enableButton('save')
            .hideError();

        this._successReportSaveConfirm(templateName);

        this._templatelist.add({
            params: orderParams,
            title: templateName,
            content: [
                u.escapeHTML(u.hellipCut(templateName, 35, '...')),
                this.hasMod('compare', 'yes') && {
                    block: 'b-icon',
                    mods: { 'size-13': 'compare-periods' },
                    mix: { block: 'b-statistic-form', elem: 'compare-periods-icon-template' }
                }
            ]
        });

        this._currentTemplate = {
            name: this._templatelist.getSelected().name,
            submitParams: this._getSubmitParams()
        };

        this.params.reportId = this._templatelist.getSelected().params.report_id;
    },

    /**
     * Возвращает параметры текущего отчета
     * @param {Boolean} [withJson] - флаг, преобразовать в JSON
     * @param {Object} ignoreExclusion - список исключений, которые надо игнорировать
     * @returns {Object}
     * @private
     */
    _getSubmitParams: function(withJson, ignoreExclusion) {
        var rangeA = this._getDateRangePicker('a').getRange(),
            rangeB = this._getDateRangePicker('b').getRange(),
            columnsSlices = this._columnsSlices.getValue(),
            ndsCheckbox = this.findBlockInside('nds-checkbox', 'checkbox'),
            resourcesCheckbox = this._resourcesCheckbox,
            filters = this._filtersEditor.getFiltersData(ignoreExclusion),
            submitParams = {
                group_by_date: this._periodGroupSelect.val(),
                region_level: this._regionLevelSelect ? this._regionLevelSelect.val() : undefined,
                page_size: this.findBlockInside('page-size-select', 'select').val(),
                date_from: rangeA.start,
                date_to: rangeA.finish
            },
            attributionControl = this.findBlockOn('attribution-control', 'select'),
            goalsSelect = this.findBlockOn('goals-select', 'select'),
            clientsSelect = this.findBlockOn('clients-select', 'clients-selector');

        if (this._goalsSelector) {
            // Если цели не выбраны - отправляем `0` как осознанный выбор пользователя,
            // иначе для МОК в `goal_ids` придут предвыбранные на бэке цели
            submitParams.goals = this._goalsSelector.getVal().join(',') || '0';
        } else if (goalsSelect) {
            submitParams.goals = goalsSelect.val();
        }

        if (clientsSelect) {
            submitParams.fl_client_id__eq = clientsSelect.getVal().join(',');
        }

        if (attributionControl) {
            submitParams.attribution_model = attributionControl.val();
        }

        if (this.hasMod('compare', 'yes')) {
            submitParams.compare_periods = 1;
            submitParams.date_from_b = rangeB.start;
            submitParams.date_to_b = rangeB.finish;
        }

        ndsCheckbox && (submitParams.with_nds = +ndsCheckbox.isChecked());

        if (resourcesCheckbox && !resourcesCheckbox.hasMod('disabled')) {
            submitParams.with_resources = +resourcesCheckbox.isChecked();
        }

        var cols = columnsSlices.columns,
            groupBy = columnsSlices.group_by;

        // Если доступно post view
        if (submitParams.attribution_model === 'last_yandex_direct_view_cross_device') {
            cols = u['b-statistics-form'].formatStatisticsToPostViewFields(cols);
            groupBy = u['b-statistics-form'].formatStatisticsToPostViewFields(groupBy);
        }

        if (withJson) {
            // DIRECT-45037: Скользящая дата в сохраненных отчетах
            if (this._getDateRangePicker('a').isRelativeRange()) {
                $.extend(submitParams, this._getRelativeParams('a'));
            }

            submitParams.json_filters = JSON.stringify(u['b-statistic-filters-editor'].toServer(filters));

            submitParams.json_columns = JSON.stringify(cols);
            submitParams.json_group_by = JSON.stringify(groupBy);
            submitParams.json_columns_positions = JSON.stringify(columnsSlices.columns_positions);
            submitParams.json_group_by_positions = JSON.stringify(columnsSlices.group_by_positions);
        } else {
            $.extend(submitParams, u['b-statistic-filters-editor'].toServerGetRequest(filters));

            submitParams.columns = cols.join(',');
            submitParams.group_by = groupBy.join(',');
            submitParams.columns_positions = columnsSlices.columns_positions.join(',');
            submitParams.group_by_positions = columnsSlices.group_by_positions.join(',');
        }

        this.params.cid && (submitParams.cid = this.params.cid);
        this.params.reportId && (submitParams.report_id = this.params.reportId);
        this.params.statType && (submitParams.stat_type = this.params.statType);

        u.consts('rights').enableStatsMultiClientsMode && (submitParams.multi_clients_mode = 1);

        return submitParams;
    },

    /**
     * Вычисляет параметры для относительных шаблонов
     * @param {String} CalendarId - id календаря
     * @private
     */
    _getRelativeParams: function(CalendarId) {
        var range = this._getDateRangePicker(CalendarId).getRange(),
            params = {
                date_range: u['b-date-range-picker'].getDiff(range.finish, range.start, 'days')
            };

        if (params.date_range == 0) {
            params.date_shift = this._getDateRangePicker(CalendarId).getShiftFromNow('days');
        }

        return params;
    },

    /**
     * Делает ajax-запрос
     * @param {Object} params - параметры
     * @returns {Deferred}
     * @private
     */
    _request: function(params) {
        var deferred = $.Deferred();

        BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            type: 'POST',
            cache: false,
            dataType: 'json',
            callbackCtx: this
        }).get(
            params,
            function(result) {
                result.error ?
                    deferred.rejectWith(this, [result.error]) :
                    deferred.resolveWith(this, arguments);
            },
            function(error) {
                deferred.rejectWith(this, arguments)
            });

        return deferred.promise();
    },

    /**
     * Скрываем/показываем строки
     * @private
     */
    _slideToggle: function() {
        var expandable = this.elem('row', 'expandable', 'yes'); // берем все схлопывающиеся строки

        expandable
            .slideToggle('slow') // скрываем или раскрываем
            .promise().done(this._onComplete.bind(this, expandable)); // когда все показаны/скрыты - вызываем обработчик
    },

    /**
     * Обработчик завершения скрытия/показа строк
     * @param {jQuery} expandable
     * @private
     */
    _onComplete: function(expandable) {
        expandable.removeAttr('style');
        this.toggleMod('unexpanded', 'yes', '');
    },

    /**
     * Строит из параметров строку и возвращает её длину
     * @param {Object} params - параметры
     * @returns {Number}
     * @private
     */
    _getRequestLength: function(params) {
        var url = '/registered/main.pl',
            location = document.location,
            requestString = u.getUrlProtocol(location) + u.extractDomain(location) + url + '?' + $.param(params || {});

        return requestString.length;
    },

    _dateRangePickers: null,

    _getDateRangePicker: function(type) {
        type || (type = 'a');
        this._dateRangePickers || (this._dateRangePickers = {});

        return this._dateRangePickers[type] ||
            (this._dateRangePickers[type] =
                this.findBlockOn(this.elem('range-picker', 'type', type), 'b-date-range-picker'));
    },

    /**
     * Проверяет корректность периода
     *
     * @param {Object} rangeA период
     * @param {Object} rangeB период
     * @returns {Boolean}
     * @private
     */
    _validateRange: function(rangeA, rangeB) {
        var aRange,
            bRange;

        if (this.hasMod('compare', 'yes')) {
            aRange = { start: u.moment(rangeA.start), finish: u.moment(rangeA.finish) };
            bRange = { start: u.moment(rangeB.start), finish: u.moment(rangeB.finish) };

            if (aRange.start.diff(bRange.start, 'days') <= 0 || aRange.start.diff(bRange.finish, 'days') <= 0) {
                BEM.blocks['b-confirm'].open({
                    message: iget2('b-statistics-form', 'data-okonchaniya-perioda-b', 'Дата окончания периода B должна быть раньше даты начала периода A'),
                    type: 'alert'
                });

                return false;
            }
        }

        return this.__base.apply(this, arguments);
    },

    /**
     * Удаляет некорректные параметры сортировки, если отключили сравнение DIRECT-54838
     * @returns {*}
     * @private
     */
    _getSortParams: function() {
        var sortParams = u._.extend({}, this.params.sortParams),
            suffixes = u['b-statistic-filters-editor'].suffixes,
            sortSuffix = typeof sortParams.sort === 'string' && u._.last(sortParams.sort.split('_'));

        // TODO должно быть на сервере DIRECT-54838
        if (!this.hasMod('compare', 'yes') && sortSuffix && suffixes.indexOf(sortSuffix) != -1) {
            sortParams = {};
        } else if (this.hasMod('compare', 'yes') && !this.params.comparePeriods) {
            sortParams = {};
        }

        if (this.params.statType) sortParams.stat_type = this.params.statType;
        if (this.params.cid) sortParams.cid = this.params.cid;
        if (+this.params.singleCamp) sortParams.single_camp = this.params.singleCamp;

        return sortParams;
    },

    _validateFilters: function(filters) {
        var filtersNames = Object.keys(filters),
            enableStatsMultiClientsMode = u.consts('rights').enableStatsMultiClientsMode,
            errors = [],
            form = this.findBlockOn(this.domElem, 'b-layout-form'),
            FILTER_MAX_PARAMS = 20,
            REQUIRED_FILTERS = ['client_id','page_id','place_id'],
            MAP_FILTER_TO_TEXT = {
                client_id: iget2('b-statistics-form', 'client-id', 'Название продукта'),
                page_id: iget2('b-statistics-form', 'page-id', 'Номер пейджа'),
                place_id: iget2('b-statistics-form', 'place-id', 'Номер плейса')
            },
            clientsSelect = this.findBlockOn('clients-select', 'clients-selector');

        function getLength(filterName) {
            if (!filters[filterName]) {
                return 0;
            }

            var filterItem = filters[filterName].eq || filters[filterName].ne;

            return (filterName === 'page_id') ? u._.unique(filterItem.split(/\D+/)).length : filterItem.length;
        }

        if (enableStatsMultiClientsMode) {

            if (REQUIRED_FILTERS.some(function(filterName) {
                return filtersNames.includes(filterName) && getLength(filterName);
            })) {
                var filtersWithErrors = []

                REQUIRED_FILTERS.forEach(function(filterName) {
                    var filterParamsLength = getLength(filterName);

                    if (filterParamsLength > FILTER_MAX_PARAMS) {
                        filtersWithErrors.push({ name: filterName, length: filterParamsLength });
                    }
                })

                if (filtersWithErrors.length) {
                    var filtersList = filtersWithErrors.map(function(filter) {
                        return '«' + MAP_FILTER_TO_TEXT[filter.name] + '» (' + filter.length + ' ' + iget2('b-statistics-form', 'shtyk', 'шт.') + ')';
                    }).join(', ');

                    errors.push(iget2(
                        'b-statistics-form',
                        'kolichestvo_elementov_bolshe_max',
                        'Для каждого фильтра можно выбрать не более {max} значений. Пожалуйста, сократите список для поля(ей): {filters}',
                        {
                            filters: { tag: 'strong', content: filtersList },
                            max: FILTER_MAX_PARAMS
                        }
                    ));
                }

            } else {
                var requiredFiltersList = REQUIRED_FILTERS.map(function(filter) {
                    return MAP_FILTER_TO_TEXT[filter];
                }).join(', ');

                errors.push(iget2(
                    'b-statistics-form',
                    'net_obyazatelnyh_parametrov',
                    'Для построения отчета выберите один из обязательных фильтров: {filters}',
                    {
                        filters: { tag: 'strong', content: requiredFiltersList }
                    }
                ));
            }
        }

        if (clientsSelect) {
            var clients = clientsSelect.getVal();

            if (!clients.length) {
                errors.push(iget2(
                    'b-statistics-form',
                    'no-mcc-clients',
                    'Для построения отчета нужно выбрать как минимум один аккаунт'
                ));
            }
        }

        if (errors.length) {
            form.showMessage(errors.map(function(error) { return { content: error }; }));

            return false;
        }

        form.hideMessage();

        return true;
    },

    /**
     * Проверят и сохраняет период. Отправляет форму отчета
     * @param {Object} [exportParams]
     * @private
     */
    _prepareSubmit: function(exportParams) {
        var rangeA = this._getDateRangePicker('a').getRange(),
            rangeB = this._getDateRangePicker('b').getRange(),
            exportDropdown = this.findBlockInside('export-dropdown', 'dropdown'),
            filters = this._filtersEditor.getFiltersData();

        if (this._validateRange(rangeA, rangeB) && this._validateFilters(filters)) {
            this._savePeriod(rangeA);

            exportDropdown && exportDropdown.hide();

            var formParams = { url: '/registered/main.pl' },
                reportParams = this._getSubmitParams(),
                requestParams = {
                    show_stat: 1,
                    cmd: 'showStat',
                    stat_periods: this._submitParams.stat_periods // формируются в _savePeriod() b-statistics-form.js
                };

            !u.consts('rights').enableStatsMultiClientsMode && (requestParams.ulogin = u.consts('ulogin'));

            $.extend(requestParams, this._getSortParams());
            $.extend(requestParams, exportParams || {});

            if (this._getRequestLength($.extend(reportParams, requestParams)) > 2048) {
                $.extend(requestParams, this._getSubmitParams(true));
                $.extend(formParams, { type: 'post' });
            } else {
                $.extend(requestParams, reportParams);
                $.extend(formParams, {
                    type: 'get',
                    elemTag: '<textarea/>' // textarea сохраняем перевод строки
                });
            }

            this.trigger('before-submit', { requestParams: requestParams, formParams: formParams });

            BEM.create({ block: 'i-request', mods: { type: 'form' } }).submit(requestParams, formParams);
        }
    },

    /**
     * Показывает предупреждение отключения сравнения периодов
     * @param {Boolean} checked - состояние кнопки compare-toggler
     * @private
     * */
    _compareOffConfirm: function(checked) {
        BEM.blocks['b-confirm'].open({
            message: iget2(
                'b-statistics-form',
                'pri-otmene-sravneniya-iz',
                'При отмене сравнения из условий фильтрации будут удалены ограничения для периода В, разницы и разницы (%)'
            ),
            textYes: iget2('b-statistics-form', 'ok', 'ОК'),
            textNo: iget2('b-statistics-form', 'otmena', 'Отмена'),
            onYes: function() {
                this._toggleCompare(checked, true);
            },
            onNo: function() {
                this._compareCheckButton.toggleMod('checked', 'yes', !checked);
            }
        }, this);
    },

    /**
     * Вызывается после изменения состояния кнопки compare-toggler
     * @param {Boolean} checked - состояние кнопки compare-toggler
     * @param {Boolean} [force] - флаг, игнорировать предупреждение
     * @private
     */
    _toggleCompare: function(checked, force) {
        if (checked) {
            this._getDateRangePicker('b')
                .getRangesChooser()
                .check('previous-period');
        }

        if (checked) {
            this._periodGroupSelect.val('none');
            this._periodGroupSelect.setMod('disabled', 'yes');

            if (this._goalsSelector) {
                this._goalsSelector.updateLimit(1);
            }
        } else {
            this._periodGroupSelect.val('day');
            this._periodGroupSelect.delMod('disabled');

            if (this._goalsSelector) {
                this._goalsSelector.updateLimit(u.consts('GOALS_MAX_NUM'));
            }
        }

        if (!force && !checked && this._filtersEditor.needCompareWarning()) {
            this._compareOffConfirm(checked);
        } else {
            this.toggleMod('compare', 'yes', checked);
            this._filtersEditor.toggleMod('compare', 'yes', checked);
            this._compareCheckButton.toggleMod('checked', 'yes', checked);
        }
    },

    /**
     * Возращает инстанс селекта «количество строк на странице»
     * @returns {BEM}
     * @private
     */
    _getPageSizeSelect: function() {
        return this._pageSizeSelect || (this._pageSizeSelect = this.findBlockInside('page-size-select', 'select'));
    },

    /**
     * Возвращает названия срезов на которые есть ограничения
     * @returns {Array}
     * @private
     */
    _getDangerousSlices: function() {
        var allSlices = u._.groupBy(this._columnsSlices.getValue().group_by),
            isSQ = this.params.statType === 'search_queries',
            dangerousSlices;

        dangerousSlices = [
            allSlices['search_query_status'] && iget2('b-statistics-form', 'status-poiskovogo-zaprosa', 'Статус поискового запроса'),
            allSlices['ext_phrase_status'] && (isSQ ? iget2('b-statistics-form', 'status-usloviya-pokaza', 'Статус условия показа') : iget2('b-statistics-form', 'status-dopolnitelnoy-frazy', 'Статус дополнительной фразы'))
        ];

        return u._.compact(dangerousSlices);
    },

    /**
     * Клик по кнопке «Показать»
     * @private
     */
    _onSubmitButtonClick: function() {
        var dangerousSlices = this._getDangerousSlices();

        // не даем смотреть статистику с 10 000 строк на странице
        // при включенных срезах «Статус условия показа» и «Статус поискового запроса»
        // в статистике появляются чекбоксы напротив каждой фразы, большое количество чекбоксов - тормозят страницу
        if (this._getPageSizeSelect().val() >= 10000 && dangerousSlices.length) {
            this._tooMuchStatisticsErrorAlert([
                iget2('b-statistics-form', 'umenshit-kolichestvo-strok-na', 'Уменьшить количество строк на странице.'),
                iget2('b-statistics-form', 'otklyuchit-slices-srezy', 'Отключить {slices}.', {
                    slices: u.pluralizeWord([
                        iget2('b-statistics-form', 'srez-s', 'срез: {foo}', {
                            foo: dangerousSlices.join(', ')
                        }),
                        iget2('b-statistics-form', 'srezy-s', 'срезы: {foo}', {
                            foo: dangerousSlices.join(', ')
                        }),
                        iget2('b-statistics-form', 'srezy-s', 'срезы: {foo}', {
                            foo: dangerousSlices.join(', ')
                        })
                    ], dangerousSlices.length),

                    context: 'slices - срезы'
                })
            ], [
                iget2(
                    'b-statistics-form',
                    'vnimanie-zagruzka-otcheta-pri',
                    'Внимание, загрузка отчета при отображении 10000 строк на странице с выбранными срезами недоступна.'
                ),
                iget2('b-statistics-form', 'pozhaluysta-poprobuyte', 'Пожалуйста, попробуйте:')
            ].join('<br>'));
        } else {
            this._prepareSubmit();
        }
    },

    /**
     * Выбирает столбцы соответствующие целям (При кейсе, когда пользователь выбрал )
     * @private
     */
    _onEmptyGoalsSelectorChange: function() {
        this._columnsSlices.tryToCheckColumns(
            ['aconv', 'agoalcost', 'agoalnum', 'agoalincome', 'agoals_profit', 'agoalroi']
        );
    },

    _onMultiGoalsSelectorChange: function(e, data) {
        this._compareCheckButton.setMod('disabled', data.value.length > 1 ? 'yes' : '');
    }

}, {

    live: function() {

        this.__base();

        this.liveBindTo('compare-toggler', 'click', function(e) {
            this.afterCurrentEvent(function() {
                this._toggleCompare(this._compareCheckButton.isChecked());
            });
        });

        return false;
    }

});
