block('b-statistics-form').mod('type', 'phrase-detail')(

    def()(function() {
        var data = this.data,
            form = data.FORM,
            showDefault = data.login_rights.role == 'support' ||
            form.goals && form.goals != '0' ||
            form.group && form.group != 'day' ||
            form.target_type && /^(search|context)$/.test(form.target_type) ||
            form.target_0 ||
            form.target_1 ||
            form.through_list ||
            form.with_nds,
            submitParams = {
                cmd: 'showCampStat',
                cid: data.cid,
                online_stat: 1,
                stat_periods: data.USER_OPTIONS.stat_periods,
                currency_archive: data.currency_archive,
                // блуждающий флаг перехода внутри статистики
                isStat: form.isStat ? 1 : undefined,
                phrasedate: 'yes'
            },
            offlineStat = data.offline_stat || form.offline_stat,
            uidPar = data.uid_par,
            fields = [];

        offlineStat && (submitParams.offline_stat = offlineStat);
        uidPar && (submitParams[uidPar.key] = uidPar.value);

        form.detail && (submitParams.detail = 1);

        ['page', 'allpages', 'interface', 'target_type'].forEach(function(name) {
            form[name] && (submitParams[name] = form[name]);
        });

        fields.push(apply('calendar'), apply('group'));
        data.directya || fields.push(apply('goals'));

        fields.push(apply('show-link'));

        !data.isCpmStat && fields.push(apply('target'));
        u['b-statistics-form'].isNeedAttribution(data.campaign) &&
            fields.push(apply('attribution'));
        data.had_nds && fields.push(apply('nds'));

        showDefault ||
            form.isStat && (showDefault = !!data.COOKIES['b-statistics-form_show-default_yes~cid:' + data.cid]);

        return {
            block: 'b-layout-form',
            mix: [{
                block: 'b-statistics-form',
                mods: {
                    'show-default': showDefault ? 'yes' : 'no'
                },
                js: {
                    submitParams: submitParams
                }
            }],
            mixes: {
                submit: {
                    block: 'b-statistics-form',
                    elem: 'submit-row'
                }
            },
            hiddenInputs: [{
                name: 'sort',
                value: form.sort && form.sort.toString()
            }, {
                name: 'save_nds',
                value: '1'
            }],
            rows: fields.map(function(i) {
                return {
                    label: {
                        content: i.label
                    },
                    control: i.control,
                    mix: (i.mix || []).concat([{
                        block: 'b-statistics-form',
                        elem: 'row',
                        elemMods: i.mods
                    }])
                };
            }),
            submit: [
                {
                    block: 'button',
                    mods: { theme: 'action' },
                    mix: [{
                        block: 'b-statistics-form',
                        elem: 'submit-button'
                    }],
                    content: iget2('b-statistics-form', 'pokazat-137', 'Показать')
                },
                applyCtx({
                    block: 'b-statistics-form',
                    elem: 'download',
                    content: {
                        elem: 'download-as-xls'
                    }
                })
            ]
        };
    }),

    mode('group')(function() {
        var group = apply('group-data') || 'day';

        return {
            label: iget2('b-statistics-form', 'gruppirovat', 'Группировать'),
            mods: {
                advanced: this.ctx.statParamsShowAll ? '' : 'yes'
            },
            control: {
                block: 'select',
                name: 'group',
                content: [
                    {
                        block: 'button'
                    },
                    {
                        elem: 'control',
                        content: [
                            {
                                title: iget2('b-statistics-form', 'po-dnyam', 'по дням'),
                                value: 'day'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-nedelyam', 'по неделям'),
                                value: 'week'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-mesyacam', 'по месяцам'),
                                value: 'month'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-kvartalam', 'по кварталам'),
                                value: 'quarter'
                            },
                            {
                                title: iget2('b-statistics-form', 'po-godam', 'по годам'),
                                value: 'year'
                            }
                        ].map(function(item) {
                            return {
                                elem: 'option',
                                attrs: u._.extend({ value: item.value },
                                    item.value == group ? { selected: 'selected' } : {}),
                                content: item.title
                            };
                        }, this)
                    }
                ]
            }
        };
    })
);
