block('b-statistics-form').mod('type', 'platform')(

    def()(function() {
        var data = this.data,
            form = data.FORM,
            showDefault = data.login_rights.role == 'support' ||
            form.goals && form.goals != '0' ||
            form.group && form.group != 'day' ||
            form.target_type && /^(search|context)$/.test(form.target_type) ||
            form.target_0 ||
            form.target_1 ||
            form.through_list ||
            form.with_nds,
            submitParams = {
                cmd: 'showCampStat',
                stat_type: form.stat_type,
                cid: data.cid,
                online_stat: 1,
                // для сквозного сохранения target_'ов для других вкладок
                target_all: form.target_all,
                target_0: form.target_0,
                target_1: form.target_1,
                stat_periods: data.USER_OPTIONS.stat_periods,
                currency_archive: data.currency_archive,
                offline_stat: data.offline_stat || form.offline_stat,
                ulogin: data.user_login,
                // блуждающий флаг перехода внутри статистики
                isStat: form.isStat ? 1 : undefined
            },
            fields = [
                apply('calendar'),
                data.directya || apply('goals'),
                !data.isCpmStat && apply('targetType'),
                u['b-statistics-form'].isNeedAttribution(data.campaign) &&
                    apply('attribution'),
                data.had_nds && apply('nds'),
                apply('show-link'),
                hasLoginRights('super_control', 'support_control', 'limited_support_control','superreader_control') && {
                    mods: {
                        border: 'top'
                    },
                    control: {
                        block: 'checkbox',
                        mods: {
                            checked: form.use_page_id ? 'yes' : ''
                        },
                        checkboxAttrs: {
                            name: 'use_page_id',
                            value: 1
                        },
                        mix: {
                            block: 'b-statistics-form',
                            elem: 'filter-page'
                        },
                        text: iget2('b-statistics-form', 'podrobno', 'Подробно')
                    }
                }
            ];

        showDefault ||
            form.isStat && (showDefault = !!data.COOKIES['b-statistics-form_show-default_yes~cid:' + data.cid]);

        return {
            block: 'b-layout-form',
            mix: [
                {
                    block: 'b-statistics-form',
                    mods: {
                        'show-default': showDefault ? 'yes' : 'no'
                    },
                    js: {
                        submitParams: submitParams
                    }
                }
            ],
            mixes: {
                submit: {
                    block: 'b-statistics-form',
                    elem: 'submit-row'
                }
            },
            hiddenInputs: [
                form.sort && {
                    name: 'sort',
                    value: form.sort.toString()
                },
                form.reverse && {
                    name: 'reverse',
                    value: form.reverse.toString()
                },
                data.had_nds && {
                    name: 'save_nds',
                    value: '1'
                }
            ],
            rows: fields.map(function(row) {
                return row ?
                    {
                        label: row.label && {
                            content: row.label
                        },
                        control: row.control,
                        mix: (row.mix || []).concat([{
                            block: 'b-statistics-form',
                            elem: 'row',
                            elemMods: row.mods
                        }])
                    } :
                    undefined;
            }),
            submit: [
                {
                    block: 'button',
                    mods: { theme: 'action' },
                    mix: [{
                        block: 'b-statistics-form',
                        elem: 'submit-button'
                    }],
                    content: iget2('b-statistics-form', 'pokazat-137', 'Показать')
                },
                applyCtx({
                    block: 'b-statistics-form',
                    elem: 'download',
                    content: {
                        elem: 'download-as-xls'
                    }
                })
            ]
        };
    }),

    mode('targetType')(function() {
        var data = this.data;

        return {
            label: iget2('b-statistics-form', 'ploshchadki', 'Площадки'),
            mods: {
                type: 'target',
                advanced: this.ctx.statParamsShowAll ? '' : 'yes'
            },
            control: {
                block: 'select',
                name: 'target_type',
                content: [
                    {
                        block: 'button'
                    },
                    {
                        elem: 'control',
                        content: [
                            {
                                value: '',
                                content: iget2('b-statistics-form', 'vse-138', 'все')
                            },
                            {
                                value: 'search',
                                content: iget2('b-statistics-form', 'poisk-134', 'поиск')
                            },
                            {
                                value: 'context',
                                content: iget2('b-statistics-form', 'seti', 'сети')
                            }
                        ].map(function(option) {
                            return {
                                elem: 'option',
                                attrs: data.FORM.target_type == option.value ?
                                    {
                                        value: option.value,
                                        selected: 'selected'
                                    } :
                                    { value: option.value },
                                content: option.content
                            };
                        })
                    }
                ]
            }
        };
    })
);
