block('b-statistics-form')(
    mode('multi-clients-label')(function() {
        return iget2('b-statistics-form', 'data-by-clients', 'Данные по аккаунтам');
    }),

    mode('multi-clients-control')(function() {
        var data = this.data,
            mcc = data.mcc,
            clients = (mcc && mcc.clients) || [],
            currentClientId = (clients.find(function(item) {
                return item.login === data.user_login;
            }) || {}).client_id,
            selectedIds;

        if (data.FORM.fl_client_id__eq) {
            selectedIds = data.FORM.fl_client_id__eq.split(',');
        } else if (currentClientId) {
            selectedIds = [currentClientId];
        }

        return [
            {
                block: 'clients-selector',
                mix: { block: this.block, elem: 'clients-select' },
                clients: clients,
                selectedIds: selectedIds
            },
        ];
    }),

    // Блок выбора периода.
    // Содержит два календаря и кнопки быстрого выбора периода
    mode('calendar')(function() {
        var data = this.data,
            period = apply('period-data'),
            statPeriods = data.FORM.stat_periods || (data.USER_OPTIONS || {}).stat_periods || '',
            limits = this.ctx.limits || {
                earlier: u['b-statistics-form'].getDateLimits().minDate.format('YYYY-MM-DD')
            },
            uniqueHash = {},
            historyRanges = [];

        statPeriods && statPeriods.split(',').forEach(function(i) {
            if (i && !uniqueHash[i]) {
                uniqueHash[i] = true;

                i = i.split(':');
                historyRanges.push({
                    start: i[0],
                    finish: i[1]
                });
            }
        });

        return {
            label: iget2('b-statistics-form', 'period', 'Период'),
            control: {
                block: 'b-date-range-picker',
                start: {
                    value: period.start,
                    limits: limits
                },
                finish: {
                    value: period.finish,
                    limits: limits
                },
                ranges: [
                    {
                        title: iget2('b-statistics-form', 'segodnya', 'сегодня'),
                        start: 0,
                        finish: 0
                    },
                    {
                        title: iget2('b-statistics-form', 'vchera', 'вчера'),
                        start: -1,
                        finish: -1
                    },
                    {
                        title: iget2('b-statistics-form', '7-dney', '7 дней'),
                        start: -7,
                        finish: 0
                    },
                    {
                        title: iget2('b-statistics-form', '30-dney', '30 дней'),
                        start: -30,
                        finish: 0
                    },
                    {
                        title: iget2('b-statistics-form', '90-dney', '90 дней'),
                        start: -90,
                        finish: 0
                    },
                    {
                        title: iget2('b-statistics-form', '365-dney', '365 дней'),
                        start: -365,
                        finish: 0
                    }
                ],
                history: statPeriods && {
                    title: iget2('b-statistics-form', 'istoriya', 'история'),
                    periods: historyRanges
                },
                dateFormat: 'YYYY-MM-DD',
                viewFormat: 'DD MMM YYYY',
                calendarMix: [{
                    block: 'b-statistics-form',
                    elem: 'date-range-picker-calendar'
                }]
            }
        };
    }),

    // Данные выбранного временного периода. Возвращает первый доступный.
    // Приоритет: URL старый формат > URL формат МОЛ > сервер старый формат > сервер формат МОЛ
    // Ответ приведен к единому формату
    mode('period-data')(function() {
        var data = this.data,
            form = data.FORM;

        return {
            start: (form.d1 ? ['20' + form.y1, form.m1, form.d1].join('-') : 0) ||
                form.date_from ||
                (data.d1 ? ['20' + data.y1, data.m1, data.d1].join('-') : 0) ||
                data.date_from,

            finish: (form.d2 ? ['20' + form.y2, form.m2, form.d2].join('-') : 0) ||
                form.date_to ||
                (data.d2 ? ['20' + data.y2, data.m2, data.d2].join('-') : 0) ||
                data.date_to
        };
    }),

    // Возвращает доступную информацию о выбранном НДС-фильтре
    mode('nds-data')(function() {
        return +this.data.FORM.with_nds || this.data.with_nds;
    }),

    // Возвращает признак надо ли выгружать ресурсы баннера при экспорта статистики в эксель
    mode('with-resources')(function() {
        return +this.data.FORM.with_resources || this.data.with_resources;
    }),

    // Доступные данные о выбранном способе группирования по дате
    mode('group-data')(function() {
        return this.data.FORM.group || this.data.FORM.group_by_date || this.data.group_by_date;
    }),

    mode('target')(function() {
        var form = this.data.FORM,
            allDisabled = this.ctx.allDisabled,
            defaultChecked = !(form.target_all || form.target_0 || form.target_1);

        return {
            label: iget2('b-statistics-form', 'ploshchadki', 'Площадки'),
            mods: {
                type: 'target',
                advanced: this.ctx.statParamsShowAll ? '' : 'yes'
            },
            control: [
                {
                    title: iget2('b-statistics-form', 'vsego-103', 'всего'),
                    name: 'target_all',
                    defaultChecked: defaultChecked
                },
                {
                    title: iget2('b-statistics-form', 'poisk-134', 'поиск'),
                    name: 'target_0'
                },
                {
                    title: iget2('b-statistics-form', 'seti', 'сети'),
                    name: 'target_1'
                }
            ].map(function(item) {
                return {
                    block: 'checkbox',
                    mods: {
                        disabled: allDisabled ? 'yes' : '',
                        checked: item.defaultChecked || form[item.name] ? 'yes' : ''
                    },
                    checkboxAttrs: {
                        name: item.name,
                        id: item.name,
                        value: 1
                    },
                    text: item.title
                };
            })
        };
    }),

    mode('nds')(function() {
        return {
            label: [
                iget2('b-statistics-form', 'nds', 'НДС'),
                {
                    block: 'b-help-link',
                    mods: {
                        type: 'modal'
                    },
                    width: 1110,
                    stretched: true,
                    url: u.getHelpUrl('include-vat')
                }
            ],
            mods: {
                advanced: this.ctx.statParamsShowAll ? '' : 'yes'
            },
            control: {
                block: 'checkbox',
                mods: {
                    checked: apply('nds-data') ? 'yes' : ''
                },
                checkboxAttrs: {
                    name: 'with_nds',
                    id: 'with_nds',
                    value: 1
                },
                text: iget2('b-statistics-form', 'vklyuchen', 'включен')
            }
        };
    }),

    mode('category')(function() {
        return {
            label: [
                iget2('b-statistics-form', 'category', 'Категория')
            ],
            control: {
                block: 'checkbox',
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'category-checkbox'
                }],
                checkboxAttrs: {
                    name: 'with_category',
                    id: 'with_category'
                }
            }
        };
    }),

    mode('campaign')(function() {
        return {
            label: [
                iget2('b-statistics-form', 'campaign', 'Кампания')
            ],
            control: {
                block: 'checkbox',
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'campaign-checkbox'
                }],
                checkboxAttrs: {
                    name: 'with_campaign',
                    id: 'with_campaign'
                }
            }
        };
    }),

    mode('multi-goals-label')(function() {
        return [
            iget2('b-statistics-form', 'data-by-goals', 'Данные по целям'),
            {
                block: 'b-help-link',
                mods: { type: 'modal' },
                stretched: true,
                icon: 'question',
                url: u.getHelpUrl('report-wizard-goal-data')
            }
        ];
    }),

    mode('multi-goals-control')(function() {
        var data = this.data,
            statType = data.FORM.stat_type,
            isShowedStat = !!data.FORM.show_stat,
            selectedGoalIds = data.goal_ids || [],
            campaign = data.campaign || {},
            goalsList = u['b-statistics-form'].getGoalsList(data.goals_list, statType, campaign.mediaType);

        return [
            {
                block: 'goals-selector',
                mix: { block: this.block, elem: 'goals-select' },
                goalsList: goalsList,
                selectedIds: selectedGoalIds,
                limit: this.data.compare_periods ? 1 : u.consts('GOALS_MAX_NUM')
            },
            data.failed_to_fetch_metrika == 1 && {
                block: 'b-notice',
                mix: {
                    block: 'b-statistics-form',
                    elem: 'metrika-warning'
                },
                mods: {
                    theme: 'inline-notification'
                },
                content: iget2('b-statistics-form', 'metrika-warning', 'Цели Метрики временно недоступны. Мы делаем все для их скорейшего возвращения. Ваша рекламная кампания работает в штатном режиме')
            },
            data.campaign && {
                block: 'b-metrika-link',
                mix: [{ block: 'b-statistics-form', elem: 'metrika-link' }],
                orderId: data.campaign.OrderID,
                metrikaCounters: data.campaign.metrika_counters,
                // в статистике фразы по дням параметр goals
                goalId: data.goal_id || (data.goals && data.goals != '0' && data.goals.split(',')[0]) || undefined,
                noPeriod: true,
                group: (['geo', 'pages', 'common', 'mol', 'moc'].indexOf(statType) !== -1) ? undefined : data.group,
                attribution: data.FORM.attribution_model || data.attribution_model
            }
        ];
    }),

    mode('goals-label')(function() {
        return iget2('b-statistics-form', 'dannye-po-celi', 'Данные по цели');
    }),

    mode('goals-control')(function() {
        var data = this.data,
            goals = data.FORM.goals,
            goalItems = data.goals_list && data.goals_list.reduce(function(result, item, index) {
                var name = item.name ? u.escapeHTML(item.name) : (iget2('b-statistics-form', 'cel', 'Цель') + ' №' + index);

                result[item.status != 'Active' ? 'idle' : 'active'].push({
                    elem: 'option',
                    attrs: u._.extend(item.goal_id == goals ? { selected: 'selected' } : {}, { value: item.goal_id }),
                    content: name
                });

                return result;
            }, {
                active: [
                    {
                        elem: 'option', //TODO goals.goals == 0 ?
                        attrs: u._.extend({ value: 0 }, !goals ? { selected: 'selected' } : {}),
                        content: iget2('b-statistics-form', 'po-vsem-celyam', 'по всем целям')
                    }
                ],
                idle: []
            }),
            statType = data.FORM.stat_type;

        goalItems = goalItems.idle.length ?
            [
                {
                    elem: 'option-group',
                    mix: [{
                        block: 'b-statistics-form',
                        elem: 'goals-group'
                    }],
                    attrs: {
                        label: iget2('b-statistics-form', 'aktivnye', 'активные')
                    },
                    content: goalItems.active
                },
                {
                    elem: 'option-group',
                    mix: [{
                        block: 'b-statistics-form',
                        elem: 'goals-group'
                    }],
                    attrs: {
                        label: iget2('b-statistics-form', 'udalennye', 'удаленные')
                    },
                    content: goalItems.idle
                }
            ] :
            goalItems.active;

        return [
            {
                block: 'select',
                name: 'goals',
                mods: { 'max-width': '400' },
                js: { elemPopupMods: { 'max-width': '400' } },
                mix: { block: this.block, elem: 'goals-select' },
                content: [
                    { block: 'button' },
                    {
                        elem: 'control',
                        content: goalItems
                    }
                ]
            },
            data.failed_to_fetch_metrika == 1 && {
                block: 'b-notice',
                mix: {
                    block: 'b-statistics-form',
                    elem: 'metrika-warning'
                },
                mods: {
                    theme: 'inline-notification'
                },
                content: iget2('b-statistics-form', 'metrika-warning', 'Цели Метрики временно недоступны. Мы делаем все для их скорейшего возвращения. Ваша рекламная кампания работает в штатном режиме')
            },
            data.campaign && {
                block: 'b-metrika-link',
                mix: [{ block: 'b-statistics-form', elem: 'metrika-link' }],
                orderId: data.campaign.OrderID,
                metrikaCounters: data.campaign.metrika_counters,
                // в статистике фразы по дням параметр goals
                goalId: data.goal_id || (data.goals && data.goals != '0' && data.goals.split(',')[0]) || undefined,
                noPeriod: true,
                group: (['geo', 'pages', 'common', 'mol', 'moc'].indexOf(statType) !== -1) ? undefined : data.group,
                attribution: data.FORM.attribution_model || data.attribution_model
            }
        ];
    }),

    mode('goals')(function() {
        return {
            label: apply('goals-label'),
            mods: {
                advanced: this.ctx.statParamsShowAll ? '' : 'yes'
            },
            control: apply('goals-control')
        }
    }),

    mode('show-link')(function() {
        return {
            mods: {
                type: 'show-button'
            },
            control: {
                block: 'check-button',
                mods: { theme: 'pseudo' },
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'show-button'
                }],
                content: iget2('b-statistics-form', 'pokazat-dopolnitelnye-nastroyki', 'Показать дополнительные настройки')
            }
        };
    }),

    mode('detail-stat')(function() {
        return {
            control: {
                block: 'checkbox',
                mix: [{
                    block: 'b-statistics-form',
                    elem: 'detail-stat'
                }],
                mods: {
                    checked: this.data.FORM.show_banners_stat ? 'yes' : ''
                },
                checkboxAttrs: {
                    id: 'show_banners_stat',
                    name: 'show_banners_stat',
                    value: 1
                },
                text: iget2('b-statistics-form', 'detalnaya-statistika-po-obyavleniyam', 'Детальная статистика по объявлениям')
            },
            mods: {
                border: 'top'
            }
        };
    }),

    mode('attribution-label')(function() {
        return {
            elem: 'attribution-label',
            content: [
                iget2('b-statistics-form', 'attribution', 'Атрибуция'),
                {
                    block: 'b-help-link',
                    mods: {
                        type: 'modal'
                    },
                    width: 1110,
                    stretched: true,
                    url: u.getHelpUrl('attribution-model')
                }
            ]
        };
    }),

    mode('attribution-display')(function() {
        var data = this.data,
            campaign = data.campaign,
            attribution_model = this.data.attribution_model,
            attribution = u._.find(
                u['b-statistics-form'].getAttributionsList(
                    data.FORM.stat_type,
                    campaign && campaign.mediaType,
                    u.campaign.hasCampByTypes(data.campaigns_list, u.campaign.cpmTypes)
                ),
                { val: attribution_model }
            ) || {};

        return attribution.text || '&mdash;';
    }),

    mode('attribution-control')(function() {
        var data = this.data,
            campaign = data.campaign,
            attribution_model = this.data.attribution_model,
            isSingleCamp = Boolean(this.data.cid),
            isFirstValueByDefault = this.ctx.isFirstValueByDefault,
            defaultValue = '',
            attributionsList = u['b-statistics-form'].getAttributionsList(
                data.FORM.stat_type,
                campaign && campaign.mediaType,
                u.campaign.hasCampByTypes(data.campaigns_list, u.campaign.cpmTypes)
            );

        isSingleCamp || isFirstValueByDefault || attributionsList.unshift({ val: '', text: '&mdash;' });

        attribution_model = attribution_model || defaultValue;

        this.attributionModel = attribution_model;

        return {
            block: 'select',
            mix: [{
                block: this.block,
                elem: 'attribution-control'
            }],
            name: 'attribution_model',
            content: [
                {
                    block: 'button',
                    content: (attributionsList.find(function(item) {
                        return item.val === attribution_model;
                    }) || {}).text
                },
                {
                    elem: 'control',
                    content: attributionsList.map(function(item) {
                        return {
                            elem: 'option',
                            attrs: u._.extend({ value: item.val },
                                item.val === attribution_model ? { selected: 'selected' } : {}),
                            content: item.text
                        };
                    }, this)
                }
            ]
        }
    }),

    mode('attribution')(function() {
        return {
            mods: { advanced: this.ctx.statParamsShowAll ? '' : 'yes' },
            label: apply('attribution-label'),
            control: apply('attribution-control')
        }
    }),

    elem('download-as-xls').content()(function() {
        var data = this.data,
            xlsFileName = [data.d1, data.m1 + '-' + data.d2, data.m2 + '_main' + data.cid, 'xls'];

        return !data.pilfer_xls ?
            {
                block: 'link',
                mods: {
                    inner: 'yes'
                },
                target: '_top',
                content: [
                    {
                        block: 'b-icon',
                        mods: {
                            type: 'xls'
                        },
                        mix: [{ block: 'link', elem: 'icon' }],
                        alt: ''
                    },
                    {
                        elem: 'inner',
                        content: iget2('b-statistics-form', 'skachat-v-vide-xls', 'скачать в виде XLS-файла')
                    }
                ],
                url: u.formatUrl({
                    path: '/registered/' + xlsFileName.join('.'),
                    query: u.getUrlParams([], {
                        xls: 1
                    })
                })
            } :
            '';
    })
);
