(function() {

    var confirm = BEM.blocks['b-confirm'];

    BEM.DOM.decl('b-statistics-form', {

        onSetMod: {
            js: function() {
                var paramsByType = {};
                this._submitParams = this.params.submitParams || {};

                this._submitParams.isStat ||
                    $.cookie('b-statistics-form_show-default_yes~cid:' + this._submitParams.cid, null);

                this.findBlockOn('submit-button', 'button').on('click', this._onSubmitButtonClick, this);
                this.exportButton = this.findBlockOn('export-button', 'button');

                if (this.exportButton) {
                    if (this._submitParams.stat_type === 'brand_safety' || this._submitParams.stat_type === 'brand_safety_mol') {
                        this.exportButton.on('click', this._onExportButtonClick, this);
                    }
                }

                BEM.channel('links-broadcast').on('stat-table-sort', this._onSortLinksBroadcastEvent, this);

                if (this._submitParams.stat_type === 'brand_safety' || this._submitParams.stat_type === 'brand_safety_mol') {
                    paramsByType[this._submitParams.stat_type.indexOf('mol') === -1 ? 'moc' : 'mol'] = {
                        open: true
                    };

                    BEM.blocks['b-metrika2'].params({
                        params: {
                            'brand-safety-stat': paramsByType
                        }
                    });
                }
            }
        },

        /**
         * Деструктор
         */
        destruct: function() {
            BEM.channel('links-broadcast').un('stat-table-sort', this._onSortLinksBroadcastEvent, this);

            this.__base.apply(this);
        },

        _onSortLinksBroadcastEvent: function(e, params) {
            if (params) {
                this._prepareSubmit({
                    sort: params.sort,
                    reverse: params.reverse
                });
            }
        },

        _submitParams: null,

        _dateRangePicker: null,

        /**
         * Возвращает блок 'b-date-range-picker'
         *
         * @returns {BEM}
         * @private
         */
        _getDateRangePicker: function() {
            return this._dateRangePicker || (this._dateRangePicker = this.findBlockInside('b-date-range-picker'));
        },

        /**
         * Возвращает период из 'b-date-range-picker'
         *
         * @returns {{start: String, finish: String}|*}
         * @private
         */
        _getDateRange: function() {
            return this._getDateRangePicker().getRange();
        },

        /**
         * Сохраняет период
         *
         * @param {Object} range период
         * @returns {BEM} this
         * @private
         */
        _savePeriod: function(range) {
            var pickerParams = this._getDateRangePicker().params,
                historyRanges = pickerParams.historyRanges || [],
                staticRangers = pickerParams.stringStaticRanges,
                currentRange = [range.start, range.finish].join(':'),
                stringRanges = [],
                duplicateRange = false;

            historyRanges.forEach(function(range) {
                var stringRange = [range.start, range.finish].join(':');

                stringRanges.push(stringRange);
                stringRange == currentRange && (duplicateRange = true);
            });

            duplicateRange || (duplicateRange = staticRangers.some(function(range) { return currentRange == range }));

            if (!duplicateRange) {
                stringRanges.unshift(currentRange);
                stringRanges.length > 3 && (stringRanges = stringRanges.slice(0, 3));
                this._submitParams.stat_periods = stringRanges.join(',');
            }

            [range.start, range.finish].forEach(function(range, index) {
                range = range.split('-');
                index++;

                ['y', 'm', 'd'].forEach(function(letter, letterIndex) {
                    this._submitParams[letter + index] = range[letterIndex];
                }, this);
            }, this);

            return this;
        },

        /**
         * Проверяет корректность периода
         *
         * @param {Object} range период
         * @returns {boolean}
         * @private
         */
        _validateRange: function(range) {
            var start = u.moment(range.start),
                finish = u.moment(range.finish);

            if (start.diff(finish, 'days') > 0) {
                confirm.alert(iget2('b-statistics-form', 'data-nachala-perioda-dolzhna', 'Дата начала периода должна быть раньше даты конца'));

                return false;
            }

            if (start.year() < 2000 || finish.year() < 2000) {
                confirm.alert(iget2(
                    'b-statistics-form',
                    'vybrannyy-period-dolzhen-nachinatsya',
                    'Выбранный период должен начинаться не раньше 1 января 2000 года'
                ));

                return false;
            }

            return true;
        },

        /**
         * Собирает данные с контролов на которые примиксован [{ block: 'b-statistics-form', elem: 'option' }]
         *
         * @private
         */
        _checkSubmitParams: function() {
            this.domElem.serializeArray().map(function(option) {
                this._submitParams[option.name] = option.value;
            }, this);

            // флаг для сброса страничной навигации при отправке формы
            // каждый раз при отправке формы нужно показывать первую страницу
            this._submitParams.showstat_button = 1;

            // блуждающий флаг перехода внутри статистики
            this._submitParams.isStat = 1;
        },

        /**
         * Клик по кнопке «Экспорт»
         *
         * @private
         */
        _onExportButtonClick: function() {
            var range = this._getDateRange();

            if (this._validateRange(range)) {
                this
                    ._savePeriod(range)
                    ._checkSubmitParams();

                this._exportDna(range);
            }
        },

        _exportDna: function(range) {
            var dna = window.dna,
                categoryCheckbox = this.findBlockInside('category-checkbox', 'checkbox'),
                campaignCheckbox = this.findBlockInside('campaign-checkbox', 'checkbox'),
                groupBy = this.findBlockInside('bs-group-select', 'select'),
                ulogin = u.consts('ulogin');

            if (!dna || !dna.utils || !dna.utils.getQueryExecutor) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            this.exportButton
                .setMod('disabled', 'yes')
                .elem('text').text(iget2('b-statistics-form', 'eksportiruetsy', 'Экспортируется...'));

            var data = {
                    startDate: range.start,
                    endDate: range.finish,
                    showCategories: categoryCheckbox ? categoryCheckbox.isChecked() : false,
                    cids: this._submitParams.cid ? this._submitParams.cid.split(',') : [],
                    showCampaigns: campaignCheckbox ? campaignCheckbox.isChecked() : false,
                    groupBy: groupBy.val()
                },
                queryExecutor = dna.utils.getQueryExecutor(ulogin);

            queryExecutor.brandSafetyExcelExport(data, ulogin, u.consts('tld'))
                .then((function(path) {
                    if (path) {
                        window.open(u.formatUrl({
                            path: path
                        }), '_self');
                    }

                    this.exportButton
                        .setMod('disabled', '')
                        .elem('text').text(iget2('b-statistics-form', 'eksport-xlsx', 'Экспорт XLSX'));
                }).bind(this));
        },

        /**
         * Клик по кнопке «Показать»
         *
         * @private
         */
        _onSubmitButtonClick: function() {
            var range = this._getDateRange();

            if (this._validateRange(range)) {
                this
                    ._savePeriod(range)
                    ._checkSubmitParams();

                this._prepareSubmit();
            }
        },

        _prepareSubmit: function(params) {
            if (this._submitParams.stat_type === 'brand_safety' || this._submitParams.stat_type === 'brand_safety_mol') {
                var paramsByType = {};

                paramsByType[this._submitParams.stat_type.indexOf('mol') === -1 ? 'moc' : 'mol'] = {
                    click: true
                };

                BEM.blocks['b-metrika2'].params({
                    params: {
                        'brand-safety-stat': paramsByType
                    }
                });
                this._submitDna(params);
                return;
            }

            this._submit(params);
        },

        prepareSubmit: function(params) {
            this._prepareSubmit(params);
        },

        /**
         * Создает и отправляет форму
         *
         * param {Object} [params] параметры
         * @private
         */
        _submit: function(params) {
            var range = this._getDateRange(),
                postParams;

            if (this._validateRange(range)) {
                this._savePeriod(range);

                this._checkSubmitParams();

                postParams = $.extend(
                    this._submitParams,
                    { online_stat: 1, offline_stat: 0 },
                    params || {});

                BEM.create({ block: 'i-request', mods: { type: 'form' } })
                    .submit(postParams, { url: '/registered/main.pl', type: 'get' }); //TODO нужен ли POST?
            }
        },

        _submitDna: function(params) {
            var range = this._getDateRange(),
                dna = window.dna,
                block = this.findBlockOutside('p-campaign-stat').findBlockInside('dna-statistic'),
                categoryCheckbox = this.findBlockInside('category-checkbox', 'checkbox'),
                campaignCheckbox = this.findBlockInside('campaign-checkbox', 'checkbox'),
                groupBy = this.findBlockInside('bs-group-select', 'select');

            if (this._validateRange(range)) {
                this._savePeriod(range);

                this._checkSubmitParams();

                dna.reactDOMRender(dna.reactCreateElement(
                    dna.components.BrandSafetyGridWrapper, {
                        login: u.consts('ulogin'),
                        campaignIds: this._submitParams.cid ? this._submitParams.cid.split(',') : [],
                        showCategories: categoryCheckbox ? categoryCheckbox.isChecked() : false,
                        showCampaigns: campaignCheckbox ? campaignCheckbox.isChecked() : false,
                        startDate: range.start,
                        endDate: range.finish,
                        clientFeatures: u.consts('clientFeaturesAll'),
                        operatorFeatures: u.consts('operatorFeaturesAll'),
                        groupBy: groupBy.val()
                    }, null), block.domElem[0]);
            }
        }

    }, {

        live: function() {
            this.liveBindTo('show-button', 'click', function() {
                this.setMod('show-default', 'yes');

                $.cookie('b-statistics-form_show-default_yes~cid:' + this._submitParams.cid, 1, { expires: 1 });
            });

            return false;
        }

    });

})();
