u.register({
    'b-statistics-form': {

        serverToClientStatKeyNamesMap: {
            client_id: 'internal_product_name'
        },
        clientToServerStatKeyNamesMap: {
            internal_product_name: 'client_id'
        },
        /**
         * Получить пределы календарных периодов
         * @param {Object} statType - Тип кампании
         * @returns {Object}
         * */
        getDateLimits: function(statType) {
            var currDate = u.moment(), // Текущая дата
                // отнимаем 1 день, т.к. считаем лимит с ТЕКУЩИМ днем
                searchQueriesSateLimit = u.consts('BS_SEARCH_QUERIES_LAST_DAYS') - 1,
                limits = {
                    ext_phrases: { minDate: u.moment(u.consts('BS_EXT_PHRASE_SINCE_DATE'), 'YYYYMMDD') },
                    search_queries: {
                        minDate: (function() {
                            var start = u.moment(u.consts('BS_SEARCH_QUERIES_SINCE_DATE'), 'YYYYMMDD'),
                                daysAgo = currDate.clone().subtract(searchQueriesSateLimit, 'days');
                            if (daysAgo.isBefore(start)) daysAgo = start;
                            return daysAgo;
                        })()
                    },
                    mo: { minDate: u.moment('2014-02-20') }, // Мастер отчетов. Три года назад
                    default: { minDate: u.moment().subtract(3, 'years').date(1) } // Три года назад
                };

            return limits[statType] || limits['default'];
        },

        getGoalsList: function(goalsFromServer, statType, mediaType) {
            var list = (goalsFromServer || []),
                goalsIdName = u['goalsIdName'];

            // DIRECT-101920
            if (statType === 'moc' && mediaType === 'mobile_content' &&
                u.consts('isUserInAppEventsInRmpEnabled') &&
                !u.consts('isTechInAppEventsInRmpEnabled')) {

                list = list.filter(function(item) {
                    return !goalsIdName[item.goal_id];
                });

                list = Object.keys(goalsIdName).map(function(key) {
                    return {
                        goal_id: key,
                        name: goalsIdName[key],
                        status: 'Active'
                    };
                }).concat(list);
            }

            return list.map(function(item, index) {
                return {
                    id: String(item.goal_id),
                    name: goalsIdName[item.goal_id] || item.name || iget2('b-statistics-form', 'cel', 'Цель') + ' №' + index,
                    status: item.status.toLowerCase(),
                    isMeaningful: item.is_meaningful_goal === '1'
                };
            });
        },

        /**
         * @typedef Attribution
         * @param {String} val - id модели
         * @param {String} text - название
         */

        /**
         * @param {String} statType - data.FORM.statType
         * @param {String | undefined} mediaType - data.campaign.mediaType
         * @param {boolean | undefined} hasCpmCamps - data.
         * Возвращает список моделий атрибуций
         * @returns [<Attribution>]
         */
        getAttributionsList: function(statType, mediaType, hasCpmCamps) {
            var initialArray = [
                {
                    val: 'last_yandex_direct_click',
                    text: iget2('b-statistics-form', 'last-direct-click', 'последний переход из Яндекс.Директа')
                },
                {
                    val: 'last_significant_click',
                    text: iget2('b-statistics-form', 'last-significant-click', 'последний значимый переход')
                },
                {
                    val: 'last_click',
                    text: iget2('b-statistics-form', 'last-click', 'последний переход')
                },
                {
                    val: 'first_click',
                    text: iget2('b-statistics-form', 'first-click', 'первый переход')
                }
            ];

            if (u.hasClientFeature('cross_device_attribution_types')) {
                initialArray.push(
                    {
                        val: 'last_yandex_direct_click_cross_device',
                        text: iget2('b-statistics-form', 'last-direct-click-cross-device', 'последний переход из Яндекс.Директа кросс-девайс')
                    },
                    {
                        val: 'last_significant_click_cross_device',
                        text: iget2('b-statistics-form', 'last-significant-click-cross-device', 'последний значимый переход кросс-девайс')
                    },
                    {
                        val: 'first_click_cross_device',
                        text: iget2('b-statistics-form', 'first-click-cross-device', 'первый переход кросс-девайс')
                    }
                );
            }

            var isCpm = u.campaign.isCpm(mediaType) || hasCpmCamps,
                isMocMol = statType === 'moc' || statType === 'mol',
                isPostViewAvailable = u.hasClientFeature('post_view_statistics');

            if (isCpm && isMocMol && isPostViewAvailable) {
                initialArray.push({
                    val: 'last_yandex_direct_view_cross_device',
                    text: iget2('b-statistics-form', 'last-yandex-direct-view-cross-device', 'последний показ из Яндекс.Директа кросс-девайс')
                });
            }

            return u._.compact(initialArray);
        },

        /**
         * Проверка, надо ли показать контрол про атрибуцию
         * @param {Object} [campaign] - данные кампании или undefined, если МОЛ
         * @returns {Boolean}
         */
        isNeedAttribution: function(campaign) {
            campaign = campaign || {};

            return campaign.mediaType !== 'mobile_content'; // показываем для всех, кроме РМП
        },

        formatStatisticsToPostViewFields: function(fields) {
            var additionalFields = {
                adepth: ['adepth', 'pv_adepth'],
                bounce_ratio: ['bounce_ratio', 'pv_bounce_ratio'],
                agoalnum: ['agoalnum', 'pv_agoalnum', 'all_agoalnum'],
                aconv: ['aconv', 'pv_aconv'],
                agoalcost: ['agoalcost', 'pv_agoalcost'],
                agoalroi: ['agoalroi', 'pv_agoalroi'],
                agoalincome: ['agoalincome', 'pv_agoalincome'],
                agoals_profit: ['agoals_profit', 'pv_agoals_profit'],
                aprgoodmultigoal: ['aprgoodmultigoal', 'pv_aprgoodmultigoal'],
                aprgoodmultigoal_cpa: ['aprgoodmultigoal_cpa', 'pv_aprgoodmultigoal_cpa'],
                aprgoodmultigoal_conv_rate: ['aprgoodmultigoal_conv_rate', 'pv_aprgoodmultigoal_conv_rate'],
                avg_time_to_conv: ['avg_time_to_conv', 'pv_avg_time_to_conv'],
                agoalcrr: ['agoalcrr', 'pv_agoalcrr']
            };

            return fields.reduce(function(acc, field) {
                return acc.concat(additionalFields[field] || field);
            }, []);
        },

        mapNamesToServerFormat: function(columns) {
            // internal_product_name должен быть заменен на client_id при отправке формы - DIRECT-123137
            return columns.map(function(column) {
                return this.clientToServerStatKeyNamesMap[column] || column;
            }.bind(this))
        },

        mapNamesToClientFormat: function(columns, isMultiClientEnabled) {
            // client_id должен быть заменен на internal_product_name в мультиклиентной статистике - DIRECT-123137
            if (isMultiClientEnabled) {
                return columns.map(function(column) {
                    return this.serverToClientStatKeyNamesMap[column] || column;
                }.bind(this))
            }

            return columns;
        }
    }
});
