block('b-statistics-metrika-counter-access')(
    def()(function() {
        var data = this.data,
            filters = data.filters,
            metrikaCounters = data.metrika_counters || {},
            campsNotInFilter = filters && filters.campaign && filters.campaign.ne,
            campsInFilter = filters && filters.campaign && filters.campaign.eq;

        if (!data.FORM.show_stat || !(data.data_array || []).length) {
            return '';
        }

        var countersWithoutAccess = [];
        var countersWithAccessNotRequested = [];
        var campsWithoutStat = [];

        for (var counterId in metrikaCounters) {
            var counterData = metrikaCounters[counterId];

            if (counterData.access === 0) {
                var cids = counterData.cids;
                if (cids && cids.length) {
                    for (var i = 0; i < cids.length; i++) {
                        var cid = cids[i],
                            isInFilteredCamps = campsInFilter && campsInFilter.length && campsInFilter.includes(cid),
                            isInNotFilteredCamps = campsNotInFilter && campsNotInFilter.length && !campsNotInFilter.includes(cid);

                        if (isInFilteredCamps || isInNotFilteredCamps || !campsInFilter && !campsNotInFilter) {
                            if (!campsWithoutStat.includes(cid)) {
                                campsWithoutStat.push(cid);
                            }
                            if (!countersWithoutAccess.includes(counterId)) {
                                countersWithoutAccess.push(counterId);
                            }
                            if (counterData.access_requested === 0 && !countersWithAccessNotRequested.includes(counterId)) {
                                countersWithAccessNotRequested.push(counterId);
                            }
                        }
                    }
                }
            }
        }

        return campsWithoutStat.length ? applyNext({
            countersWithoutAccess: countersWithoutAccess,
            countersWithAccessNotRequested: countersWithAccessNotRequested,
            campsWithoutStat: campsWithoutStat,
        }) : '';
    }),
    js()(function() {
        return {
            ulogin: this.data.user_login,
            countersWithAccessNotRequested: this.countersWithAccessNotRequested,
        }
    }),
    content()(function() {
        var getPluralizeCampaignsText = function(campaignsNumber) {
            return iget2('b-statistics-metrika-counter-access', 'pluralize-campaigns', '{number} кампаниях', {
                count: campaignsNumber,
                one: '{number} кампании',
                some: '{number} кампаниях',
                many: '{number} кампаниях',
                number: campaignsNumber
            });
        };
        return {
            block: 'b-notice-tooltip',
            key: 'counter_stat_access_message',
            expires: 30 * 6,
            mods: { theme: 'light', size: 'n' },
            mix: { elem: 'counter-access-message', block: 'b-statistics-metrika-counter-access' },
            content: [
                iget2('b-statistics-metrika-counter-access', 'stat-disabled', 'Статистика по целям в {campCount} скрыта, так как у вас нет доступа к данным на счётчиках.', {
                    campCount: getPluralizeCampaignsText(this.campsWithoutStat.length)
                }),
                {
                    block: 'b-statistics-metrika-counter-access',
                    elem: 'request-info',
                    elemMods: { access: this.countersWithAccessNotRequested.length > 0 ? 'no' : 'requested' }
                }
            ]
        }
    })
);
