block('b-statistics-template-list').elem('dropdown').elemMod('type', 'display-conditions').def()(function() {
    var selectedTemplate = {};

    this.ctx.templates.forEach(function(item) {
        item.selected && (selectedTemplate = item);
    });

    return applyCtx({
        block: 'dropdown',
        mix: [
            {
                block: 'b-statistics-template-list',
                elem: 'dropdown'
            },
            {
                block: 'b-dropdown-chooser',
                js: true
            }
        ],
        content: [
            {
                block: 'link',
                mods: { pseudo: 'yes' },
                mix: [
                    {
                        block: 'b-statistics-template-list',
                        elem: 'switcher'
                    },
                    {
                        block: 'dropdown',
                        elem: 'switcher'
                    }
                ],
                content: {
                    block: 'b-statistics-template-list',
                    elem: 'title',
                    selectedTitle: selectedTemplate.title
                }
            },
            {
                elem: 'popup',
                elemMods: { animate: 'no' },
                mix: [{
                    block: 'b-statistics-template-list',
                    elem: 'popup'
                }],
                js: {
                    directions: ['bottom-left', 'top-left'],
                    tail: {
                        offset: 10
                    } // DIRECT-40545 Съезжает хвостик у попапа
                },
                content: {
                    block: 'b-chooser',
                    mix: [
                        {
                            block: 'b-statistics-template-list',
                            elem: 'templates'
                        },
                        {
                            block: 'b-dropdown-chooser',
                            elem: 'chooser'
                        }
                    ],
                    content: this.ctx.templates.map(function(item) {
                        return {
                            elem: 'item',
                            elemMods: {
                                selected: item.selected ? 'yes' : ''
                            },
                            mix: [{
                                block: 'b-statistics-template-list',
                                elem: 'template'
                            }],
                            js: {
                                title: item.title,
                                params: item.params
                            },
                            content: item.title,
                            name: u._.uniqueId('template-')
                        };
                    })
                }
            }
        ]
    });
});
