block('b-statistics-template-list').elem('dropdown').def()(function() {
    var selectedTemplate = {};

    this.ctx.templates.forEach(function(item) {
        item.selected && (selectedTemplate = item);
    });

    return applyCtx({
        block: 'dropdown',
        mix: [
            {
                block: 'b-statistics-template-list',
                elem: 'dropdown'
            },
            {
                block: 'b-dropdown-chooser',
                js: true
            }
        ],
        content: [
            {
                block: 'link',
                mods: { pseudo: 'yes' },
                mix: [
                    {
                        block: 'b-statistics-template-list',
                        elem: 'switcher'
                    },
                    {
                        block: 'dropdown',
                        elem: 'switcher'
                    }
                ],
                content: {
                    block: 'b-statistics-template-list',
                    elem: 'title',
                    elemMods: this.ctx.blockType ? { type: this.ctx.blockType } : {},
                    selectedTitle: selectedTemplate.title,
                    defaultTitle: this.ctx.defaultTitle
                }
            },
            {
                elem: 'popup',
                elemMods: { animate: 'no' },
                mix: [{
                    block: 'b-statistics-template-list',
                    elem: 'popup'
                }],
                js: {
                    directions: ['bottom-left', 'top-left'],
                    tail: {
                        offset: 10
                    } // DIRECT-40545 Съезжает хвостик у попапа
                },
                content: {
                    block: 'b-chooser',
                    mix: [
                        {
                            block: 'b-statistics-template-list',
                            elem: 'templates'
                        },
                        {
                            block: 'b-dropdown-chooser',
                            elem: 'chooser'
                        }
                    ],
                    content: [{
                        elem: 'item',
                        js: {
                            title: this.ctx.defaultTitle,
                            params: {}
                        },
                        mix: [{
                            block: 'b-statistics-template-list',
                            elem: 'template'
                        }],
                        content: this.ctx.resetTitle || iget2('b-statistics-template-list', 'novyy-filtr', 'Новый фильтр'),
                        name: 'reset'
                    }]
                        .concat(this.ctx.templates.map(function(item) {
                            return {
                                elem: 'item',
                                elemMods: {
                                    with: 'remove',
                                    selected: item.selected ? 'yes' : ''
                                },
                                mix: [{
                                    block: 'b-statistics-template-list',
                                    elem: 'template'
                                }],
                                js: {
                                    title: item.title,
                                    params: item.params,
                                    statType: item.statType
                                },
                                content: item.content || u.escapeHTML(u.hellipCut(item.title, 35, '...')),
                                name: u._.uniqueId('template-')
                            };
                        }))
                }
            }
        ]
    });
});
