BEM.DOM.decl('b-statistics-template-list', {

    onSetMod: {
        js: function() {
            this.findBlocksInside('dropdown').length && this._initEvents();
        }
    },

    /**
     * Отписывается от событий
     * @returns {BEM}
     * @private
     */
    _unBindEvents: function() {
        this._chooser && this._chooser.un('change');

        this._dropdown && this._dropdown
            .un('show')
            .un('hide');

        return this;
    },

    /**
     * Подписывается на события
     * @returns {BEM}
     * @private
     */
    _initEvents: function() {
        this._dropdown = this.findBlockInside('dropdown')
            .on('show', this._onShow, this)
            .on('hide', this._onHide, this);

        this._chooser = this.findBlockInside('b-chooser')
            .on('change', this._onChooserChange, this)
            .on('removing', this._onChooserRemoving, this)
            .on('remove', function(e, data) {
                this.afterCurrentEvent(function() {
                    this._onChooserRemove(e, data);
                });
            }, this);

        this._setTemplates();

        this._title = this.findElem('title');

        return this;
    },

    _templates: null,

    /**
     * Записывает параметры шаблонов
     * @param {Object} [data] - новый шаблон
     *  @param {String} data.title - название(показывается пользователю)
     *  @param {String} data.name - имя
     *  @param {Object} data.params - набор настроек
     * @returns {BEM}
     * @private
     */
    _setTemplates: function(data) {
        if (data) {
            this._templates || (this._templates = []);

            this._templates.push({
                title: data.title,
                params: data.params,
                statType: data.statType,
                name: data.name
            });
        } else {
            this._templates = this._chooser.getAll().map(function(item) {
                return {
                    title: item.title,
                    params: item.params,
                    statType: item.statType,
                    name: item.name
                };
            });
        }

        return this;
    },

    /**
     * Удаляет шаблон из списка
     * @param {String} name - имя
     * @returns {BEM}
     * @private
     */
    _removeTemplates: function(name) {
        this._templates = (this._templates || []).filter(function(template) {
            return template.name != name;
        });

        return this;
    },

    /**
     * Устанавливает модификатор open ▲
     * @returns {BEM}
     * @private
     */
    _onShow: function() {
        return this.setMod(this._title, 'open', 'yes');
    },

    /**
     * Удаляет модификатор open ▼
     * @returns {BEM}
     * @private
     */
    _onHide: function() {
        return this.delMod(this._title, 'open');
    },

    /**
     * Возвращает количество шаблонов
     * @returns {Number|undefined}
     * @private
     */
    _getTemplatesCount: function() {
        return this._chooser && this._chooser.getAll().length - 1 || 0;
    },

    /**
     * Устанавливает заголовок
     * @param {String} title - название(показывается пользователю)
     * @returns {BEM}
     * @private
     */
    _setTitle: function(title) {
        this._title.text(title);

        return this;
    },

    /**
     * Устанавливает стандартный заголовок
     * @returns {BEM}
     * @private
     */
    _setDefaultTitle: function() {
        this.domElem.text(this.params.defaultTitle);

        return this;
    },

    /**
     * Триггерит событие removing
     * @param {Event} e
     * @param {Object} data
     * @returns {BEM}
     * @private
     */
    _onChooserRemoving: function(e, data) {
        return this.trigger('removing', data);
    },

    /**
     * Удаляет dropdown если нет шаблонов
     * @param {Event} e
     * @param {Object} data
     * @returns {BEM}
     * @private
     */
    _onChooserRemove: function(e, data) {
        if (!this._getTemplatesCount()) {
            this._setDefaultTitle()
                ._unBindEvents();

            this._dropdown.destruct();

            this._templates = null;
            this._chooser = null;
        }

        return this
            ._removeTemplates(data.name)
            .trigger('remove', data);
    },

    /**
     * Устанавливает заголовок, скрывает popup
     * @param {Event} e
     * @param {Object} data
     * @returns {BEM}
     * @private
     */
    _onChooserChange: function(e, data) {
        if (data.selected) {
            this._setTitle(data.title, data.name == 'reset');
            this._dropdown
                .getPopup().hide();

            data.extraParams.from != 'addTemplate' && this.trigger('select', this.getSelected(data.title));

            // reset — «Новый шаблон»
            data.name == 'reset' && this._chooser.uncheck('reset');
        }

        return this;
    },

    /**
     * Проверяет существование шаблона по title, возвращает его
     * @param {String} title - название
     * @returns {Object}
     */
    findTemplate: function(title) {
        var template;

        (this._templates || []).forEach(function(item) {
            item.title == title && (template = item);
        });

        return template;
    },

    select: function(name) {
        this._chooser.check(name || 'reset');

        return this;
    },

    /**
     * Возвращает выбранный шаблон
     * @param {String} title - название
     * @returns {Object}
     */
    getSelected: function(title) {
        var selected = null;

        title || (title = this._chooser && (this._chooser.getSelected() || {}).title);

        title && (this._templates || []).forEach(function(item) {
            item.title == title && (selected = item);
        });

        return selected;
    },

    /**
     * Удаляет шаблон
     * @param {String} templateName
     * @returns {remove}
     */
    remove: function(templateName) {
        this._chooser.remove(templateName);

        return this;
    },

    /**
     * Обрабатывает ошибку
     * @param {Object} error
     * @returns {BEM}
     */
    onError: function(error) {
        this._chooser.onError(error);

        return this;
    },

    /**
     * Добавляет новый шаблон
     * @param {Object} [data] - новый шаблон
     *  @param {String} data.title - название(показывается пользователю)
     *  @param {String} data.name - имя
     *  @param {Object} data.params - набор настроек
     * @returns {BEM}
     */
    add: function(data) {
        var templateName = u._.uniqueId('new-template-'); // уникальный id необходим для b-chooser

        if (this._chooser) {
            var savedTemplate = this.findTemplate(data.title),
                JSONelem = {
                    elemMods: { with: 'remove' },
                    mix: [{
                        block: 'b-statistics-template-list',
                        elem: 'template'
                    }],
                    js: {
                        title: data.title,
                        params: data.params,
                        statType: data.statType
                    },
                    content: data.content,
                    name: templateName
                };

            if (savedTemplate) {
                this._removeTemplates(savedTemplate.name);
                this._chooser.replace(savedTemplate.name, JSONelem);
            } else {
                this._chooser.add(JSONelem);
            }

            this._setTemplates($.extend({ name: templateName }, data));

            this._chooser.check(templateName, { from: 'addTemplate' });
        } else {
            BEM.DOM.update(this.domElem, BEMHTML.apply({
                block: 'b-statistics-template-list',
                elem: 'dropdown',
                defaultTitle: this.params.defaultTitle,
                resetTitle: this.params.resetTitle,
                blockType: this.getMod('type'),
                templates: [{
                    selected: true,
                    title: data.title,
                    params: data.params,
                    statType: data.statType,
                    content: data.content
                }]
            }));

            this._initEvents()
                ._setTemplates();
        }

        return this;
    }

}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('init', 'dropdown');

    }

});
