block('b-statistics-template-saving').replace()(function() {
    var input = this.ctx.input || {},
        switcher = this.ctx.switcher || {},
        mix = [{
            block: 'b-statistics-template-saving',
            mods: this.mods,
            js: true
        }].concat(this.ctx.mix || []);

    return {
        block: 'dropdown',
        mix: mix,
        content: [
            {
                block: 'button',
                mods: {
                    size: switcher.size || 's',
                    theme: switcher.theme || '',
                    disabled: switcher.disabled || ''
                },
                mix: [
                    {
                        block: 'dropdown',
                        elem: 'switcher'
                    },
                    {
                        block: 'b-statistics-template-saving',
                        elem: 'switcher'
                    }
                ],
                content: switcher.text || iget2('b-statistics-template-saving', 'sohranit-v-shablon', 'Сохранить в шаблон')
            },
            {
                elem: 'popup',
                elemMods: { animate: 'no' },
                mix: [{
                    block: 'b-statistics-template-saving',
                    elem: 'popup'
                }],
                content: [
                    {
                        block: 'input',
                        mods: { autocomplete: 'off' },
                        mix: [{
                            block: 'b-statistics-template-saving',
                            elem: 'template'
                        }],
                        value: input.value || '',
                        placeholder: input.hint || iget2('b-statistics-template-saving', 'nazvanie-shablona', 'название шаблона'),
                        content: [
                            { elem: 'control' }
                        ]
                    },
                    {
                        block: 'b-statistics-template-saving',
                        elem: 'error'
                    },
                    {
                        block: 'b-statistics-template-saving',
                        elem: 'popup-buttons',
                        content: [
                            {
                                block: 'button',
                                mods: { disabled: input.value ? '' : 'yes' },
                                mix: [{
                                    block: 'b-statistics-template-saving',
                                    elem: 'save'
                                }],
                                content: iget2('b-statistics-template-saving', 'sohranit', 'Сохранить')
                            },
                            {
                                block: 'button',
                                mix: [{
                                    block: 'b-statistics-template-saving',
                                    elem: 'cancel'
                                }],
                                content: iget2('b-statistics-template-saving', 'otmena', 'Отмена')
                            }
                        ]
                    }
                ]
            }
        ]
    };
});
