BEM.DOM.decl('b-statistics-template-saving', {

    onSetMod: {

        js: function() {
            this._dropdown = this.findBlockOn('dropdown');

            this._errorElem = this.elem('error');
            this._buttons = {};

            ['save', 'cancel', 'switcher'].forEach(function(name) {
                this._buttons[name] = this.findBlockInside(name, 'button');
            }, this);

            this.bindTo(this.getInput().elem('control'), 'keypress', function(e) {
                if (e.keyCode === 13 && this.getInput().val()) {
                    this._onSave();
                }
            });

            this.getInput().on('change', function() {
                this
                    ._checkButton()
                    .hideError();
            }, this);
            this._getButton('save').on('click', this._onSave, this);
            this._getButton('cancel').on('click', function() {
                this
                    .hidePopup()
                    .hideError();
            }, this);
        }

    },

    /**
     * Триггерит событие save
     * @returns {BEM}
     * @private
     */
    _onSave: function() {
        return this.trigger('save', $.trim(this.getInput().val()));
    },

    /**
     * Устанавливает значение инпута
     * @param {String} value - новый текст
     * @returns {BEM}
     */
    setValue: function(value) {
        this.getInput().val(value);

        return this;
    },

    /**
     * Возвращает инпут
     * @returns {BEM}
     */
    getInput: function() {
        return this._input || (this._input = this.findBlockInside('template', 'input'));
    },

    /**
     * Показывает ошибку
     * @param {String} error - текст ошибки
     * @returns {BEM}
     */
    showError: function(error) {
        this._errorElem.text(error);

        return this.setMod(this._errorElem, 'show', 'yes');
    },

    /**
     * Скрывает ошибку
     * @returns {BEM}
     */
    hideError: function() {
        return this.delMod(this._errorElem, 'show');
    },

    /**
     * Разрешает/запрещает сохранять
     * @returns {BEM}
     * @private
     */
    _checkButton: function() {
        return this.getInput().val() ?
            this.enableButton('save') :
            this.disableButton('save');
    },

    /**
     * Устанавливает фокус на input, когда открывается popup
     * @returns {BEM}
     * @private
     */
    _onShow: function() {
        this.getInput().setMod('focused', 'yes');

        return this._checkButton();
    },

    /**
     * Возвращает button
     * @param {String} name - имя кнопки ('save', 'cancel', 'switcher')
     * @returns {BEM}
     * @private
     */
    _getButton: function(name) {
        return this._buttons[name];
    },

    /**
     * Делает button неактивным
     * @param {String} name
     * @returns {BEM}
     */
    disableButton: function(name) {
        this._getButton(name).setMod('disabled', 'yes');

        return this;
    },

    /**
     * Делает button активным
     * @param {String} name
     * @returns {BEM}
     */
    enableButton: function(name) {
        this._getButton(name).delMod('disabled');

        return this;
    },

    /**
     * Возвращает popup
     * @returns {BEM}
     */
    getPopup: function() {
        return this._dropdown.getPopup();
    },

    /**
     * Скрывает popup
     * @returns {BEM}
     */
    hidePopup: function() {
        this.getPopup().hide();

        return this;
    }

}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('init', 'dropdown')
            .liveInitOnBlockInsideEvent('show', 'dropdown', function() {
                this._onShow();
            });

    }

});
