block('b-strategy-choose-easy-popup')(

    def().match(function() {
        return !!this.data.banners.length && this.data.login_rights.role !== 'superreader';
    })(function() {
        return applyNext({
            'ctx.canChange': true
        });
    }),

    addJs()(function() {
        return {
            canChange: this.ctx.canChange
        };
    }),

    content()(function() {
        return [
            {
                elem: 'title-wrapper',
                content: {
                    elem: 'title',
                    canChange: this.ctx.canChange,
                    strategyData: this.data.campaign,
                    currencyName: u.currencies.getName(this.data.campaign.currency, {
                        isPseudo: 1
                    })
                }
            },
            {
                block: 'spin',
                mix: [{
                    block: 'b-strategy-choose-easy-popup',
                    elem: 'spin'
                }],
                mods: {
                    theme: 'gray-16'
                }
            },
            {
                block: 'popup',
                mods: {
                    autoclosable: 'no'
                },
                js: {
                    directions: ['right', 'bottom']
                },
                mix: [{
                    block: 'b-strategy-choose-easy-popup',
                    elem: 'popup'
                }].concat(this.ctx.mix || []),
                content: [
                    {
                        elem: 'tail'
                    },
                    {
                        elem: 'content',
                        content: [
                            {
                                block: 'b-strategy-choose-easy-popup',
                                elem: 'popup-center',
                                content: applyCtx({
                                    block: 'b-strategy-choose-easy',
                                    mods: {
                                        popup: 'yes'
                                    }
                                })
                            },
                            {
                                block: 'b-strategy-choose-easy-popup',
                                mix: this.ctx.mixes && this.ctx.mixes.buttons,
                                elem: 'popup-buttons',
                                content: [
                                    {
                                        block: 'button',
                                        mix: [{
                                            block: 'b-strategy-choose-easy-popup',
                                            elem: 'accept-button'
                                        }],
                                        content: this.ctx.acceptButtonText || iget2('b-strategy-choose-easy-popup', 'sohranit', 'Сохранить')
                                    },
                                    {
                                        block: 'button',
                                        mix: [{
                                            block: 'b-strategy-choose-easy-popup',
                                            elem: 'decline-button'
                                        }],
                                        content: iget2('b-strategy-choose-easy-popup', 'zakryt', 'Закрыть')
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                block: 'b-strategy-choose-easy',
                elem: 'models-block'
            }

        ];
    }),

    elem('effective-recalculation').content()(function() {
        return {
            block: 'b-icon-text',
            iconType: 'tick',
            content: iget2('b-strategy-choose-easy-popup', 'posmotret-recalculation-prognoz-effektivnogo', 'Посмотреть {recalculation}', {
                recalculation: function(text) {
                    return {
                        block: 'link',
                        mods: {
                            pseudo: 'yes'
                        },
                        mix: [{
                            block: 'b-strategy-choose-easy-popup',
                            elem: 'switcher-link'
                        }],
                        content: text
                    };
                }(iget2(
                    'b-strategy-choose-easy-popup',
                    'posmotret-recalculation-prognoz-effektivnogo-param-recalculation',
                    'прогноз эффективного бюджета'
                )),

                context: 'recalculation - прогноз эффективного бюджета'
            })
        };
    }),

    elem('attention').content()(function() {
        return {
            block: 'b-icon-text',
            mix: this.ctx.mixes && this.ctx.mixes.iconText,
            content: [
                iget2(
                    'b-strategy-choose-easy-popup',
                    'pri-tekushchem-nabore-klyuchevyh',
                    'При текущем наборе ключевых фраз недельный бюджет может быть не&nbsp;выполнен. <br/>Необходимо отредактировать объявление, добавив несколько ключевых фраз.'
                ),
                {
                    block: 'b-help-link',
                    url: u.getHelpUrl('light-add-keywords'),
                    text: iget2('b-strategy-choose-easy-popup', 'kak-podobrat-klyuchevye-frazy', 'Как подобрать ключевые фразы?')
                }
            ]
        };
    })
);
