BEM.DOM.decl('b-strategy-choose-easy-popup', {
    onSetMod: {
        js: function() {
            this.forecast = BEM.blocks['i-easy-budget-forecast'];

            u.graspSelf.call(this, {
                _spin: 'spin on spin',
                _popup: 'popup on popup',
                _acceptButton: 'button on accept-button',
                _declineButton: 'button on decline-button',
                _switcher: '? button on switcher-button'
            });

            this._initStrategyBlock();

            this
                ._initModels()
                ._bindEvents({ isBind: true });

            this._loadCampaignData();
        },

        loading: function(modName, modVal) {
            this._spin.setMod('progress', modVal);
            this._switcher && this._switcher.setMod('disabled', modVal);
            this._acceptButton.setMod('disabled', modVal);
            this._declineButton.setMod('disabled', modVal);
        }
    },

    /**
     * Обновляем текст рядом с блоком стратегии
     * @param {Object} strategyData
     * @private
     */
    _updateTitle: function(strategyData) {
        BEM.DOM.update(
            this.elem('title-wrapper'),
            BEMHTML.apply({
                block: 'b-strategy-choose-easy-popup',
                elem: 'title',
                canChange: this.params.canChange,
                currencyName: u.currencies.getName(this.campModel.get('currency'), { isPseudo: 1 }),
                strategyData: strategyData
            }),
            function() {
                // кнопка перерисовывается
                this.dropElemCache('switcher-button');

                u.graspSelf.call(this, { _switcher: '? button on switcher-button' });
            },
            this);
    },

    destruct: function() {
        this._bindEvents({ isBind: false });

        return this.__base.apply(this, arguments);
    },

    /**
     *
     * @param {Object} options
     * @param {Boolean} options.isBind
     * @private
     */
    _bindEvents: function(options) {
        var actionName = options.isBind ? 'on' : 'un';

        this._acceptButton[actionName]('click', this._saveStrategy, this);
        this._declineButton[actionName]('click', this._declineStategy, this);
        this._popup[actionName]('hide', this._declineStategy, this);
    },

    /**
     * Сохранение стратегии
     * @private
     */
    _saveStrategy: function() {
        if (!this._strategyBlock.isValid()) return;

        var campModel = this.campModel,
            data = this._strategyBlock.provideData(),
            requestData = $.extend({
                cmd: 'ajaxSaveAutobudget',
                pseudo_currency_id: campModel.get('pseudo_currency_id'),
                cid: campModel.get('cid'),
                ulogin: u.consts('ulogin'),
                budget_strategy: campModel.get('strategy')
            }, data);

        this.setMod('loading', 'yes');

        BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            cache: false,
            dataType: 'json',
            type: 'POST',
            callbackCtx: this
        }).get(
            requestData,
            function() {
                this.delMod('loading');

                this._strategyBlock.fixStrategyData();

                this._updateTitle(data);
                this._updateWarning(data);
                this._hidePopup();

                this._checkEffectiveRecalculation();
            },
            function() {
                this.delMod('loading');
                BEM.blocks['b-confirm'].alert(iget2('b-strategy-choose-easy-popup', 'pri-sohranenii-byudzheta-proizoshla', 'При сохранении бюджета произошла ошибка'));
            });
    },

    /**
     * Предупреждение о невыполнении недельного бюджета
     * @param {Object} data
     * @returns {BEM}
     * @private
     */
    _updateWarning: function(data) {
        if (!this.forecast) {
            return this;
        }
        this.setMod(this.elem('attention'),
            'hidden',
            data.manual_autobudget_sum <= this.forecast.getCurrentInstance().getMaxBudget() ? 'yes' : '');

        return this;
    },

    /**
     * Отмена изменений в попапе
     * @private
     */
    _declineStategy: function() {
        this._strategyBlock.declineStrategyData();

        this._hidePopup();
    },

    /**
     * Инициализируем необходимые для блока модели и привязываем к ним события
     * @returns {BEM}
     */
    _initModels: function() {
        this.campModel = BEM.MODEL.getOrCreate({ name: 'm-easy-campaign', id: 'campaign' });

        return this;
    },

    /**
     * Возвращает модель стратегии
     * @return {BEM.MODEL}
     * @private
     */
    _getStrategyModel: function() {
        return this._strategyModel ||
            (this._strategyModel = BEM.MODEL.getOrCreate({ name: 'm-easy-strategy-distributed' }));
    },

    /**
     * Открываем/закрываем попап со стратегиями
     * @returns {BEM}
     * @private
     */
    _togglePopup: function() {
        if (this._popup.isShown()) {
            this._declineStategy();

            return this;
        } else {
            this.setMod('loading', 'yes');

            this.
                _loadCampaignData()
                .always(function() { this.delMod('loading'); }.bind(this))
                .then(function() { this._openPopup(); }.bind(this))
                .fail(function() {
                    BEM.blocks['b-confirm'].alert(iget2('b-strategy-choose-easy-popup', 'nevozmozhno-zagruzit-dannye-po', 'Невозможно загрузить данные по стратегии'));
                });
        }

        return this;
    },

    /**
     * Закрываем попап со стратегиями
     * @private
     */
    _hidePopup: function() {
        this._popup.hide();
    },

    /**
     * Открываем попап со стратегиями
     * @private
     */
    _openPopup: function() {
        this._popup.show(this.elem('switcher-button'));
    },

    /**
     * Инициализируем блок со стратегиями внутри попапа
     * @returns {BEM}
     * @private
     */
    _initStrategyBlock: function() {
        this._strategyBlock = this.findBlockInside(this._popup.domElem, 'b-strategy-choose-easy');

        //пустой блок this._strategyBlock  допустим в тестах
        this._strategyBlock && this._strategyBlock.initBlocks();

        return this;
    },

    /**
     * Загружаем данные о стратегиях на кампании
     * @returns {$.Deferred}
     */
    _loadCampaignData: function() {
        if (this._currentForecastInstance) return this._currentForecastInstance;

        var campData = this.campModel.toJSON(),
            ulogin = campData.ulogin || u.consts('ulogin'),
            requestParams = {
                pseudo_currency_id: this.campModel.get('pseudo_currency_id'),
                convUnitRate: this.campModel.get('rate')
            };

        if (ulogin) requestParams.ulogin = ulogin;

        requestParams.cid = campData.cid;

        this._currentForecastInstance = this.forecast
            .loadCampaignPhrases({ phrases: [], geo: '' }, requestParams)
            .then(function(currentInstance) {
                this._checkEffectiveRecalculation();

                return currentInstance;
            }.bind(this));

        return this._currentForecastInstance;
    },

    /**
     * Проверяет предложен ли эффективный бюджет
     * @private
     */
    _checkEffectiveRecalculation: function() {
        if (!this.params.canChange) return;

        if ($.cookie('b-strategy-choose-easy-popup~effective-recalc-prevent~cid:' + this.campModel.get('cid'))) return;

        var isSuccess = this.campModel.get('forecastStatus') === 'success',
            strategyModel = this._getStrategyModel(),
            allowRefinement = strategyModel.get('manual_autobudget_sum') <
                this.forecast.getCurrentInstance().getRecomendedBudget();

        this.toggleMod(this.elem('effective-recalculation'), 'hidden', 'yes', !(isSuccess && allowRefinement));
    }

}, {

    live: function() {
        this.liveBindTo('switcher-button', 'pointerclick', function(e) {
            e.preventDefault();

            this._togglePopup();
        });

        return false;
    }

});
