block('b-strategy-setting').mod('name', 'avg-click')(

    js()(function() {
        return {
            modelName: 'b-strategy2-settings_name_avg-click',
            modelData: {
                name: 'autobudget_avg_click',
                currency: this.ctx.currency,
                metrika: {},
                weekBidEnabled: false,
                maxClickBidEnabled: false,
                avgClickBid: this.ctx.value,
                clickBidType: 'avg'
            }
        }
    }),

    elem('controls').content()(function() {
        var currency = this.ctx.currency;

        return [
            {
                block: 'input',
                mix: [
                    {
                        block: this.block,
                        elem: 'model-field',
                        js: {
                            name: 'avgClickBid',
                            type: 'formatted-input'
                        }
                    },
                    {
                        block: this.block,
                        elem: 'error-anchor'
                    },
                    {
                        block: this.block,
                        elem: 'input',
                        elemMods: {
                            name: 'avgClickBid'
                        }
                    }
                ],
                mods: {
                    theme: 'normal',
                    size: 's'
                },
                content: [
                    { elem: 'control' }
                ],
                value: this.ctx.value
            },
            iget2('b-strategy-setting', 'avg-week', '{currency} в среднем за неделю', {
                currency: u.currencies.getName(currency)
            })
        ]
    })
)
