block('b-strategy-setting').mod('name', 'cpi')(

    js()(function() {

        return {
            modelName: 'b-strategy2-settings_name_cpi',
            modelData: {
                name: 'autobudget_avg_cpi',
                currency: this.ctx.currency,
                metrika: {},
                rmpCounters: this.ctx.rmpCounters,
                weekBidEnabled: false,
                maxClickBidEnabled: false ,
                cpi: this.ctx.value,
                external: true
            }
        }
    }),

    elem('controls').content()(function() {
        var currency = this.ctx.currency;

        return [
            {
                block: 'input',
                mix: [
                    {
                        block: this.block,
                        elem: 'model-field',
                        js: {
                            name: 'cpi',
                            type: 'formatted-input'
                        }
                    },
                    {
                        block: this.block,
                        elem: 'error-anchor'
                    },
                    {
                        block: this.block,
                        elem: 'input',
                        elemMods: {
                            name: 'cpi'
                        }
                    }
                ],
                mods: {
                    theme: 'normal',
                    size: 's'
                },
                content: [
                    { elem: 'control' }
                ],
                value: this.ctx.value
            },
            iget2('b-strategy-setting', 'avg-week', '{currency} в среднем за неделю', {
                currency: u.currencies.getName(currency)
            })
        ]
    })
)
