BEM.DOM.decl({ block: 'b-strategy-setting', baseBlock: 'i-glue' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this.model.on('change', this._onModelChange, this)
        }
    },

    /**
     * Возвращает текущее значение
     * @return {{strategyData: {name: *, options: *, is_net_stopped: boolean}, dayBudgetData: boolean}}
     */
    getValue: function() {
        return {
            strategyData: {
                name: this.model.get('name'),
                options: this.model.get('options'),
                is_net_stopped: false
            },
            dayBudgetData: false
        }
    },

    /**
     * Проверяет валидно ли текущее состояние
     * @return {Boolean}
     */
    isValid: function() {
        return this.model.isValid();
    },

    /**
     * Выполняет валидацию и показ ошибок
     * @return {boolean}
     */
    validate: function() {
        if (!this.isValid()) {
            (this.model.validate().errorFields || []).forEach(this._validateField, this);

            return false;
        }

        return true;
    },

    /**
     * Обработчик изменения модели
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onModelChange: function(e, data) {
        var field = data.field;
        this._validateField(field);
        this.trigger('change', this.getValue());
    },

    /**
     * Валидирует конкретное поле и показывает ошибку
     * @param {String} field
     * @private
     */
    _validateField: function(field) {
        var modelField = this.model.fields[field],
            elemField = this.elem('input', 'name', field);

        if (!modelField.isValid()) {
            var errors = (modelField.validate().invalidRules || []);
            elemField.length && this._showTooltip(elemField, this._getErrorsText(errors));
            elemField.length && this.blockInside(elemField, 'input').setMod('error', 'yes');
        } else {
            this._hideTooltip();
            elemField.length && this.blockInside(elemField, 'input').delMod('error');
        }
    },

    /**
     * Формирует текст ошибки
     * @param {Array<Object>} errorsData
     * @return {string}
     * @private
     */
    _getErrorsText: function(errorsData) {
        var errors = [];

        errorsData.some(function(error, index) {
            // Всегда добавляем первое сообщение валидации и сообщения, помеченные required
            (index == 0 || error.text.required) && errors.push(error.text);

            // Заканчиваем добавлять ошибки, если в правиле есть флаг only
            return error && error.text && error.text.only;
        });

        return errors.join('. ');
    },

    /**
     * Показывает подсказку
     * @param {jQuery} domElem
     * @param {String} text
     * @private
     */
    _showTooltip: function(domElem, text) {
        this._tipman || (this._tipman = BEM.create('tipman', {
            tipMods: { theme: 'white' },
            popupDirections: ['right', 'bottom'],
            delay: 50,
            onScrollClose: false
        }));

        text.length > 0 && this._tipman.show({
            owner: domElem,
            content: text
        });
    },

    /**
     * Прячет подсказку
     * @private
     */
    _hideTooltip: function() {
        this._tipman && this._tipman.hide();
    }

});
