block('b-strategy2-settings').elem('metrika-warning')(

    content()(function() {
        var warningText = this.ctx.text,
            helpLinkUrl = this.ctx.helpLinkUrl;

        return warningText ? [
            warningText,
            helpLinkUrl && {
                elem: 'help-link',
                tag: 'span',
                content: [
                    ' ',
                    {
                        block: 'b-help-link',
                        mods: { type: 'modal', margin: 'no' },
                        url: helpLinkUrl,
                        text: iget2('b-strategy2-settings', 'podrobnee', 'Подробнее')
                    }
                ]
            }
        ] : [];
    }),

    elemMod('name', 'no-metrika')(

        content()(function() {
            var warningText = this.ctx.text,
                helpLinkUrl = this.ctx.helpLinkUrl;

            return warningText ? [
                iget2(
                    'b-strategy2-settings',
                    'dlya-name-ustanovite-metrika',
                    'Для {name} установите {metrika}, задайте {goals} и дождитесь по крайней мере одного целевого визита.',
                    {
                        name: warningText,

                        metrika: function(text) {
                            return {
                                block: 'b-help-link',
                                mods: { margin: 'no' },
                                url: u.getMetrikaUrl('list'),
                                text: text
                            };
                        }(iget2('b-strategy2-settings', 'dlya-name-ustanovite-metrika-param-metrika', 'Метрику')),

                        goals: function(text) {
                            return {
                                block: 'b-help-link',
                                mods: { margin: 'no' },
                                url: u.getCommonHelpUrl('/metrika/general/goals.xml'),
                                text: text
                            };
                        }(iget2('b-strategy2-settings', 'dlya-name-ustanovite-metrika-param-goals', 'цели')),

                        context: 'metrika - Метрику; goals - цели'
                    }
                ),
                helpLinkUrl && {
                    elem: 'help-link',
                    tag: 'span',
                    content: [
                        ' ',
                        {
                            block: 'b-help-link',
                            mods: { type: 'modal', margin: 'no' },
                            url: helpLinkUrl,
                            text: iget2('b-strategy2-settings', 'podrobnee', 'Подробнее')
                        }
                    ]
                }
            ] : [];
        })
    ),

    elemMod('name', 'no-metrika-optional-visits')(

        content()(function() {
            var warningText = this.ctx.text,
                helpLinkUrl = this.ctx.helpLinkUrl;

            return warningText ? [
                iget2(
                    'b-strategy2-settings',
                    'metrika-needed',
                    'Для {name} установите {metrika} и задайте {goals}.',
                    {
                        name: warningText,

                        metrika: function(text) {
                            return {
                                block: 'b-help-link',
                                mods: { margin: 'no' },
                                url: u.getMetrikaUrl('list'),
                                text: text
                            };
                        }(iget2('b-strategy2-settings', 'dlya-name-ustanovite-metrika-param-metrika', 'Метрику')),

                        goals: function(text) {
                            return {
                                block: 'b-help-link',
                                mods: { margin: 'no' },
                                url: u.getCommonHelpUrl('/metrika/general/goals.xml'),
                                text: text
                            };
                        }(iget2('b-strategy2-settings', 'dlya-name-ustanovite-metrika-param-goals', 'цели')),

                        context: 'metrika - Метрику; goals - цели'
                    }
                ),
                helpLinkUrl && {
                    elem: 'help-link',
                    tag: 'span',
                    content: [
                        ' ',
                        {
                            block: 'b-help-link',
                            mods: { type: 'modal', margin: 'no' },
                            url: helpLinkUrl,
                            text: iget2('b-strategy2-settings', 'podrobnee', 'Подробнее')
                        }
                    ]
                }
            ] : [];
        })
    )
);
