/**
 * Панель настроек стратегии "Снижение цены повторных показов" для cpm_banner кампаний
 */
BEM.DOM.decl({ name: 'b-strategy2-settings', modName: 'name', modVal: 'cpm-max-coverage' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._reachMetrikaGoal();
            this._subscriptionManager.wrap(this.model)
                .on('spendMode', 'change', function(e, data) {
                    this._reachMetrikaGoal();
                }, this)
        },
        show: {
            yes: function() {
                this._reachMetrikaGoal();
            }
        }
    },

    _reachMetrikaGoal: function() {
        var mediaType = this.model.get('mediaType'),
            coverageMode = this.getMod(this.elem('coverage-control'), 'spend-mode');

        if (coverageMode === 'period') {
            BEM.blocks['b-metrika2'].reachGoal(
                mediaType === 'cpm_banner' ?
                    'CPM_STRATEGY_REPEATED_PERIOD' :
                    'DEALS_STRATEGY_REPEATED_PERIOD'
            );
        }

        if (coverageMode === 'week') {
            BEM.blocks['b-metrika2'].reachGoal(
                mediaType === 'cpm_banner' ?
                    'CPM_STRATEGY_REPEATED_WEEKLY' :
                    'DEALS_STRATEGY_REPEATED_WEEKLY'
            );
        }
    }

});
