/**
 * Панель настроек стратегии "Максимум показов по минимальной цене" для cpm_banner кампаний
 */
BEM.DOM.decl({ name: 'b-strategy2-settings', modName: 'name', modVal: 'cpm-max-shows' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._reachMetrikaGoal();
            this._subscriptionManager.wrap(this.model)
                .on('spendMode', 'change', function(e, data) {
                    this._reachMetrikaGoal();
                }, this)
        },
        show: {
            yes: function() {
                this._reachMetrikaGoal();
            }
        }
    },

    _reachMetrikaGoal: function() {
        var mediaType = this.model.get('mediaType'),
            coverageMode = this.getMod(this.elem('coverage-control'), 'spend-mode');

        if (coverageMode === 'week') {
            BEM.blocks['b-metrika2'].reachGoal(
                mediaType === 'cpm_banner' ?
                    'CPM_STRATEGY_MAXIMP_WEEKLY' :
                    'DEALS_STRATEGY_MAXIMP_WEEKLY'
            );
        }

        if (coverageMode === 'period') {
            BEM.blocks['b-metrika2'].reachGoal(
                mediaType === 'cpm_banner' ?
                    'CPM_STRATEGY_MAXIMP_PERIOD' :
                    'DEALS_STRATEGY_MAXIMP_PERIOD'
            );
        }
    }
});
