(function() {
    var warnings = {
        autobudget_avg_cpa: {
            'metrika-domains-count': iget2(
                'b-strategy2-settings',
                'vnimanie-ne-rekomenduetsya-ispolzovat',
                'Внимание! Не рекомендуется использовать среднюю цену конверсии в кампаниях, рекламирующих более одного сайта.'
            ),
            'metrika-goal-deleted': iget2(
                'b-strategy2-settings',
                'vnimanie-vybrannaya-cel-udalena2',
                'Внимание! Выбранная цель удалена, для эффективной работы выберите другую цель.'
            ),
            'metrika-apc-deviation': iget2(
                'b-strategy2-settings',
                'vnimanie-kolichestvo-celevyh-vizitov',
                'Внимание! Количество целевых визитов на сайт резко изменилось. Стоимость конверсии может значительно отличаться от заданного значения.'
            ),
            'metrika-cpa-deviation': ''
        },
        autobudget_optimization_cpa: {
            'metrika-domains-count': iget2(
                'b-strategy2-settings',
                'vnimanie-ne-rekomenduetsya-ispolzovat-100',
                'Внимание! Не рекомендуется использовать оптимизацию рентабельности рекламы в кампаниях, рекламирующих более одного сайта.'
            ),
            'metrika-goal-deleted': iget2(
                'b-strategy2-settings',
                'vnimanie-vybrannaya-cel-udalena',
                'Внимание! Выбранная цель удалена, для эффективной работы выберите цель с достаточным количеством целевых визитов.'
            ),
            'metrika-apc-deviation': iget2(
                'b-strategy2-settings',
                'vnimanie-kolichestvo-celevyh-vizitov',
                'Внимание! Количество целевых визитов на сайт резко изменилось. Стоимость конверсии может значительно отличаться от заданного значения.'
            ),
            'metrika-cpa-deviation': ''
        },
        autobudget_roi: {
            'metrika-domains-count': iget2(
                'b-strategy2-settings',
                'vnimanie-ne-rekomenduetsya-ispolzovat-100',
                'Внимание! Не рекомендуется использовать оптимизацию рентабельности рекламы в кампаниях, рекламирующих более одного сайта.'
            ),
            'metrika-goal-deleted': iget2(
                'b-strategy2-settings',
                'vnimanie-vybrannaya-cel-udalena',
                'Внимание! Выбранная цель удалена, для эффективной работы выберите цель с достаточным количеством целевых визитов.'
            ),
            'metrika-apc-deviation': '',
            'metrika-cpa-deviation': ''
        },
        autobudget: {
            'metrika-domains-count': iget2(
                'b-strategy2-settings',
                'vnimanie-ne-rekomenduetsya-ispolzovat-101',
                'Внимание! Не рекомендуется использовать недельный бюджет по конверсии в кампаниях, рекламирующих более одного сайта.'
            ),
            'metrika-goal-deleted': iget2(
                'b-strategy2-settings',
                'vnimanie-vybrannaya-cel-udalena',
                'Внимание! Выбранная цель удалена, для эффективной работы выберите цель с достаточным количеством целевых визитов.'
            ),
            'metrika-apc-deviation': '',
            'metrika-cpa-deviation': ''
        }
    };

    u.register({

        'b-strategy2-settings': {
            /**
             * Возвращает текст предупреждения про метрику по идентификатору стратегии и коду ошибки
             * @param {String} name имя модели, для которой рассчитываем данные
             * @param {Object} metrika
             * @param {String} goalId
             * @param {String} where
             * @returns {String}
             */
            getMetrikaWarningsText: function(name, metrika, goalId, where, metrikaCounter) {
                var warningsForCurrentName = u._.extend({
                        'no-metrika': u['b-strategy2-settings'].getNoMetrikaStrategyText(name),
                        'no-metrika-optional-visits': u['b-strategy2-settings'].getNoMetrikaStrategyText(name)
                    }, warnings[name] || {}),
                    code = u.getMetrikaWarning(
                        metrika,
                        goalId,
                        where,
                        name,
                        u['b-strategy2-settings'].getMinGoalsOnCampaign(),
                        metrikaCounter
                    );

                return code ? { code: code, text: warningsForCurrentName[code] } : {};
            },

            isMetrikaDisabled: function(name, metrika, goalId, where, metrikaCounter) {
                var code = u.getMetrikaWarning(
                    metrika,
                    goalId,
                    where,
                    name,
                    u['b-strategy2-settings'].getMinGoalsOnCampaign(),
                    metrikaCounter
                );

                return code === 'no-metrika' || code === 'metrika-no-cpi-data' || code === 'no-metrika-optional-visits';
            },

            /**
             * Формирование текста про отсутствие Метрики
             * @param {String} strategyName - идентификатор стратегии
             * @returns {String}
             */
            getNoMetrikaStrategyText: function(strategyName) {
                return {
                    autobudget_avg_cpa: iget2('b-strategy2-settings', 'optimize-cpa-switch-on', 'подключения оптимизации конверсий'),
                    autobudget_optimization_cpa: iget2(
                        'b-strategy2-settings',
                        'podklyucheniya-optimizacii-kolichestva-konversiy',
                        'подключения оптимизации количества конверсий'
                    ),
                    autobudget_roi: iget2('b-strategy2-settings', 'optimize-roi-switch-on', 'подключения оптимизации рентабельности'),
                    autobudget: iget2('b-strategy2-settings', 'optimize-cpa-switch-on', 'подключения оптимизации конверсий')
                }[strategyName];
            },

            /**
             * Возвращает ссылку на хэлп для заданной стратегии
             * @param {String} strategyName - идентификатор ссылки
             * @returns {String}
             */
            getHelpLinkUrl: function(strategyName) {
                return u.getHelpUrl(strategyName);
            },

            /**
             * Вовзращает минимальное количество целей кампании
             * @returns {*}
             */
            getMinGoalsOnCampaign: function() {
                return u.consts('MIN_GOALS_ON_CAMPAIGN');
            },

            /**
             * Возвращает цветовое распределение по переданной валюте
             * TODO DIRECT-75565 @skywhale унести на бекенд
             * @param {String} currency - валюта
             * @param {Number} min - максимальное значение
             * @param {Number} max - минимальное значение
             * @returns {Array}
             */
            getGradientColors: function(currency, min, max) {
                return {
                    RUB: [
                        { name: '#ff0000', range: [min, 15] },
                        { name: '#ffff00', range: [45, 65] },
                        { name: '#4CAF50', range: [115, max] }
                    ],
                    KZT: [
                        { name: '#ff0000', range: [min, 90] },
                        { name: '#ffff00', range: [270, 390] },
                        { name: '#4CAF50', range: [690, max] }
                    ],
                    BYN: [
                        { name: '#ff0000', range: [min, 0.5] },
                        { name: '#ffff00', range: [1.5, 2.17] },
                        { name: '#4CAF50', range: [4.03, max] }
                    ],
                    UAH: [
                        { name: '#ff0000', range: [min, 6.8] },
                        { name: '#ffff00', range: [20.40, 29.47] },
                        { name: '#4CAF50', range: [51.75, max] }
                    ],
                    CHF: [
                        { name: '#ff0000', range: [min, 0.25] },
                        { name: '#ffff00', range: [0.75, 1.08] },
                        { name: '#4CAF50', range: [1.73, max] }
                    ],
                    USD: [
                        { name: '#ff0000', range: [min, 0.26] },
                        { name: '#ffff00', range: [0.78, 1.13] },
                        { name: '#4CAF50', range: [1.73, max] }
                    ],
                    EUR: [
                        { name: '#ff0000', range: [min, 0.22] },
                        { name: '#ffff00', range: [0.66, 0.95] },
                        { name: '#4CAF50', range: [1.73, max] }
                    ],
                    TRY: [
                        { name: '#ff0000', range: [min, 0.89] },
                        { name: '#ffff00', range: [2.67, 3.86] },
                        { name: '#4CAF50', range: [6.9, max] }
                    ]
                }[currency];
            },

            /**
             * Дефолтное значение CPM
             * TODO DIRECT-75565 @skywhale унести на бекенд
             */
            CPM_PERIOD_DEFAULT_PRICE: {
                RUB: 100,
                KZT: 600,
                BYN: 3.5,
                UAH: 45,
                CHF: 1.5,
                USD: 1.5,
                EUR: 1.5,
                TRY: 6
            },

            /**
             * Максимальный период для стратегии
             */
            MAX_STRATEGY_PERIOD: 90,

            /**
             * Стандартный период стратегии
             */
            DEFAULT_STRATEGY_PERIOD: 30,

            /**
             * Возвращает настройки для календаря b-date-range-picker с модификатором type_super
             * @param {Object} params
             * @param {String} params.campaignStart - дата начала кампании
             * @param {String} [params.campaignFinish] - дата окончания кампании
             * @param {String} [params.strategyStart] - дата начала сохраненной стратегии
             * @param {String} [params.strategyFinish] - дата окончания сохраненной стратегии
             * @returns {Object}
             */
            getCalendarSettings: function(params) {
                var campaignStart = params.campaignStart,
                    campaignFinish = params.campaignFinish,
                    defaultStart = u.moment().format('YYYY-MM-DD'), // стандартная дата старта сегодняшний день
                    defaultFinish,
                    defaultMaxDate, // максимальная дата в календаре, всё что старше не выбирается
                    start,
                    finish;

                // если дата окончания кампании в прошлом, то выставляем текущую дату,
                // в интерфейсе с таким календарем работать нельзя(будет задизейблен)
                if (campaignFinish && u['b-date-range-picker'].getDiff(defaultStart, campaignFinish, 'days') <= 0) {
                    return {
                        start: defaultStart,
                        finish: defaultStart,
                        range: 0,
                        minDate: defaultStart,
                        maxDate: u['b-date-range-picker'].getDateFrom(1, defaultStart),
                        isSuperButtonDisabled: true
                    };
                }

                // если дата старта кампании в будущем то дату старта стратегии переносим к старту кампании
                start = u['b-date-range-picker'].getDiff(campaignStart, defaultStart, 'days') < 0 ?
                    campaignStart :
                    defaultStart;

                // учитываем сегодняшний день поэтому - 1
                defaultFinish = u['b-date-range-picker'].getDateFrom(this.DEFAULT_STRATEGY_PERIOD - 1, start);
                // вообще максимальной даты в этом кейсе  быть не  должно, но пришлось сделать просто большое число,
                // потому что если в b-date-range-picker с модификатором super передать maxDate undefined -
                // он установить ее сам в сегодня + 1, менять логику в нем я не хочу, так как используется он
                // не только в стратегиях и придется смотреть регрессию
                defaultMaxDate = u['b-date-range-picker'].getDateFrom(365 * 20, start);

                if (campaignFinish) {
                    // если дата окончания кампании раньше стандартного окончания периода,
                    // то дату окончания стратегии переносим к окончанию кампании
                    finish = u['b-date-range-picker'].getDiff(campaignFinish, defaultFinish, 'days') < 0 ?
                        defaultFinish :
                        campaignFinish;

                    if (u['b-date-range-picker'].getDiff(campaignFinish, defaultMaxDate, 'days') > 0) {
                        defaultMaxDate = u['b-date-range-picker'].getDateFrom(1, campaignFinish);
                    }
                } else {
                    finish = defaultFinish;
                }

                return {
                    start: start,
                    finish: finish,
                    range: u.moment(finish).diff(u.moment(start), 'day') + 1, // учитываем сегодняшний день + 1
                    minDate: u.moment(start).format('YYYY-MM-DD'),
                    maxDate: defaultMaxDate
                };
            },

            getPlatforms: function() {
                return [
                    {
                        platform: u.strategy.ALL,
                        title: iget2('b-strategy2-settings', 'platform-na-vseh-ploshchadkah', 'На всех площадках')
                    },
                    {
                        platform: u.strategy.SEARCH,
                        title: iget2('b-strategy2-settings', 'platform-tolko-na-poiske', 'Только на поиске')
                    },
                    {
                        platform: u.strategy.NET,
                        title: iget2('b-strategy2-settings', 'platform-tolko-v-setyah', 'Только в сетях')
                    }
                ];
            }

        }

    });

})();
