block('b-success-stories')(

    js()(true),

    def()(function() {
        return this.ctx.stories ? applyNext() : '';
    }),

    content()(function() {
        return [
            {
                elem: 'title',
                tag: 'h2',
                content: iget2('b-success-stories', 'istorii-uspeha-nashih-klientov', 'Истории успеха наших клиентов')
            },
            {
                elem: 'container',
                stories: this.ctx.stories
            },
            {
                elem: 'more-wrap',
                content: {
                    block: 'link',
                    mix: [
                        {
                            block: 'b-success-stories',
                            elem: 'more',
                            elemMods: { show: this.ctx.stories.length > 3 ? 'yes' : 'no' }
                        },
                        {
                            block: 'b-metrika',
                            js: {
                                goal: 'SHOW_MORE',
                                counter: '34'
                            }
                        },
                        {
                            block: 'b-metrika',
                            js: {
                                goal: 'SHOW_MORE',
                                counter: '191494'
                            }
                        }
                    ],
                    mods: { pseudo: 'yes' },
                    content: iget2('b-success-stories', 'pokazat-eshche', 'Показать еще')
                }
            }
        ];
    }),

    elem('container').content()(function() {
        var rows = [],
            currentRow;

        this.ctx.stories.forEach(function(story, num) {
            var storyElem = {
                elem: 'story',
                story: story
            };

            if (!(num % 3)) {
                currentRow && rows.push(currentRow);

                currentRow = {
                    elem: 'row',
                    mix: [{ block: 'i-clearfix' }],
                    elemMods: { show: rows.length ? 'no' : 'yes' },
                    content: []
                };

                storyElem.elemMods = { gap: 'no' };
            }

            currentRow.content.push(storyElem);
        });

        rows.push(currentRow);

        return rows;
    }),

    elem('story').content()(function() {
        var storyUrl = this.ctx.story.url;

        return {
            block: 'link',
            mods: { theme: 'black' },
            mix: [
                {
                    block: 'b-success-stories',
                    elem: 'story-wrap-link'
                },
                {
                    block: 'b-metrika',
                    js: {
                        goals: [{
                            goal: 'story_click',
                            counter: '191494'
                        },
                        {
                            goal: 'story_click',
                            counter: '34'
                        }]
                    }
                }
            ],
            url: storyUrl,
            content: [
                {
                    block: 'b-success-stories',
                    elem: 'story-image',
                    tag: 'img',
                    attrs: {
                        width: '102px',
                        height: '102px',
                        alt: this.ctx.story.company,
                        src: this.ctx.story.image
                    }
                },
                {
                    block: 'b-success-stories',
                    tag: 'h3',
                    elem: 'story-company',
                    content: this.ctx.story.company
                },
                {
                    block: 'b-success-stories',
                    elem: 'story-quote',
                    content: '«' + this.ctx.story.quote + '»'
                }
            ]
        };
    })
);
