BEM.DOM.decl('b-survey', {

    /**
     * Обработчик события click на элементе edit
     * @private
     */
    _onEditClick: function() {
        this.trigger('edit', this.params);
    },

    /**
     * Обработчик события click на элементе remove
     * триггерит событие remove c данными
     * @private
     */
    _onRemoveClick: function() {
        this.trigger('remove', {
            survey_id: this.params['survey-id'],
            delete_survey: 1
        });
    }

}, {

    live: function() {

        this
            .liveBindTo('edit', 'click', function() {
                this._onEditClick();
            })
            .liveBindTo('remove', 'click', function() {
                this._onRemoveClick();
            });
    }

});
