BEM.DOM.decl('b-switch-to-dna-panel', {

    onSetMod: {

        js: function() {
            this._metrika = BEM.blocks['b-metrika2'];
            this._metrika.reachGoal('NEW_INTERFACE_NOTIF_SHOW');

            this._subMan = BEM.create('i-subscription-manager');
            this._subMan
                .on(this.findBlockInside('switch', 'button2'), 'click', this._goToDna, this)
                .on(this.findBlockInside('close', 'button2'), 'click', function() {
                    this._metrika.reachGoal('NEW_INTERFACE_NOTIF_CLOSED');
                    this._closePanel();
                }, this);
        }
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base.apply(this);
    },

    /**
     * Прячем панель после клика
     * @private
     */
    _closePanel: function() {
        $.cookie(u['b-switch-to-dna-panel'].getCookieName(), 1, { expires: 100 * 365 });

        this.setMod('visibility', 'hidden')
    },

    /**
     * Переход в dna
     * @private
     */
    _goToDna: function() {
        this._metrika.reachGoal('NEW_INTERFACE_NOTIF_ACCEPTED');

        this._closePanel();
        BEM.blocks['i-switch-to-dna'].doSwitch(true);
    }
});
