BEM.DOM.decl({ block: 'b-tableau-trigger' }, {
    TABLEAU_OFFSET: 375,
    TABLEAU_WIDTH: 380,
    THREE_ROWS_HEIGHT: 420,
    FOUR_ROWS_HEIGHT: 510,
    ICON_WIDTH: 24,

    onSetMod: {
        js: function() {
            var lang = u.consts('lang'),
                rusServices = [
                    'metrika',
                    'partners',
                    'direct-api',
                    'commander',
                    'market',
                    'kassa',
                    'money',
                    'sprav',
                    'telephony',
                    'mail',
                    'audience',
                    'surveys'
                ],
                foreignServices = [
                    'metrika',
                    'partners-en',
                    'direct-api',
                    'commander',
                    'market',
                    'kassa',
                    'money',
                    'sprav',
                    'disk',
                    'mail',
                    'audience'
                ];

            this._resize = BEM.blocks['i-resize'].getInstance();

            this._tableau = $.Tableau({
                serviceId: 'direct',
                lang: lang,
                domain: u.consts('tld'),
                device: 'desktop',
                width: this.TABLEAU_WIDTH,
                height: this.FOUR_ROWS_HEIGHT,
                target: 'blank',
                services: (lang === 'ru' ? rusServices : foreignServices).join('+')
            });

            this._setTableauPos();
            this._initTableauEvents();
        },

        active: {
            yes: function() {
                this._setTableauPos();
                this._tableau.open();
            },
            '': function() {
                this._tableau.close();
            }
        }
    },

    /**
     * уничтожает блок табло
     */
    destruct: function() {
        this.findBlockInside('link').un('click');
        this._resize.un('start end');
        this.unbindFromDoc('click');

        this.__base();

        this._tableau.destruct();
    },

    /**
     * Устанавливает положение табло
     * @private
     */
    _setTableauPos: function() {
        // блок header2 - ЛЕГОшный с live-авторизацией, чтобы
        // передавать от него параметры дом-элемента, придется его весь переписать
        var parent = this.findBlockOutside(this.params.parentName).domElem,
            position = parent.position().top + parent.height(),
            icon = this.findBlockInside('link').domElem;

        this._tableau.setPos({
            top: position,
            left: icon.offset() - 15,
            tail: 10
        });
    },

    /**
     * инициализация событий: проброска событий табло
     * скрывание табло по клику на страницу
     * сдвиг табло при ресайзе
     * @private
     */
    _initTableauEvents: function() {
        this.bindToDomElem($(this._tableau.getNode()), 'init open close destruct', function(e) {
            this.trigger(e.type);
            e.stopPropagation();
        });

        this.bindToDoc('click', function(e) {
            if (!this.containsDomElem($(e.target)) && this._tableau.isOpened()) {
                this._toggleTableau();
            }
        });

        this._resize.on('start end', function() {
            if (this._tableau.isOpened()) {
                this._setTableauPos();
            }
        }, this);
    },

    /**
     * Включение-выключение табло
     * @private
     */
    _toggleTableau: function() {
        this.toggleMod('active', '', 'yes', this._tableau.isOpened());
    }

}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'link', function() {
            this._toggleTableau();
        });
    }
});
