block('b-teaser').mod('mode', 'regular')(

    match(function() { return this.ctx.teaser; }).content()(function() {
        var ctx = this.ctx,
            teaser = ctx.teaser,
            currencyPayedLen = (teaser.currencyPayed || []).length,
            mixes = ctx.mixes,
            isInfoblock = this.mods.infoblock == 'yes',
            buttons = (teaser.buttons || []).map(function(button) {
                return {
                    block: 'button',
                    mods: {
                        theme: button.theme || 'normal',
                        pseudo: isInfoblock ? 'yes' : ''
                    },
                    mix: [{
                        block: 'b-teaser',
                        elem: 'action-button'
                    }].concat(button.mixes, (mixes && mixes.button)),
                    url: button.link,
                    attrs: button.target ? { target: button.target } : '',
                    content: button.text
                };
            }),
            applyTitleMods = function(elem) {
                // превращаем обычные ссылки в псевдоссылки,
                // чтобы перед переходом по ней вызывалась функция-обработчик
                elem.block == 'link' &&
                    (elem.mods = u._.extend(elem.mods || {},
                        {
                            pseudo: 'yes',
                            theme: 'direct'
                        }
                    ));

                return elem;
            };

        if (!teaser.noClose) {
            buttons.push({
                block: 'button',
                mods: { theme: 'clear' },
                mix: [
                    {
                        block: 'b-teaser',
                        elem: 'close-button'
                    }
                ].concat(mixes ? mixes.close : []),
                content: [
                    {
                        block: 'spin',
                        mods: { theme: 'gray-16' },
                        mix: mixes && mixes.spin
                    },
                    iget2('b-teaser', 'zakryt', 'Закрыть')
                ]
            });
        }

        return [
            {
                block: 'b-teaser',
                elem: 'wrap',
                content: [
                    {
                        elem: 'content',
                        elemMods: { currency: currencyPayedLen ? 'yes' : '' },
                        content: [
                            !teaser.disableIcon && {
                                elem: 'icon',
                                elemMods: {
                                    'no-left-margin': !!this.ctx.clientMustConvert && this.ctx.isInternalRole ?
                                        'yes' :
                                        ''
                                },
                                content: [
                                    { block: 'b-icon' },
                                    currencyPayedLen == 1 && {
                                        block: 'b-teaser',
                                        elem: 'currency-icon',
                                        elemMods: {
                                            type: teaser.currencyIconType.toLowerCase()
                                        }
                                    }
                                ]
                            },
                            {
                                elem: 'content-wrap',
                                content: [
                                    teaser.title && {
                                        elem: 'title',
                                        // иногда title - массив, иногда - строка
                                        content: u._.isArray(teaser.title) ?
                                            teaser.title.filter(function(elem) {
                                                return !!elem.block
                                            }).map(applyTitleMods(elem)) :
                                            applyTitleMods(teaser.title)
                                    },
                                    {
                                        elem: 'info',
                                        content: [
                                            {
                                                elem: 'text',
                                                content: teaser.text
                                            },
                                            currencyPayedLen > 1 && [
                                                teaser.prependIconToSelect && {
                                                    elem: 'icon',
                                                    elemMods: {
                                                        'no-left-margin': !!this.ctx.clientMustConvert &&
                                                        this.ctx.isInternalRole ?
                                                            'yes' :
                                                            ''
                                                    },
                                                    content: [
                                                        { block: 'b-icon' },
                                                        currencyPayedLen == 1 && {
                                                            block: 'b-teaser',
                                                            elem: 'currency-icon',
                                                            elemMods: {
                                                                type: teaser.currencyIconType.toLowerCase()
                                                            }
                                                        }
                                                    ]
                                                },
                                                {
                                                    block: 'select',
                                                    name: 'currency-teaser',
                                                    mix: [{ block: 'b-teaser', elem: 'multicurrency-select' }],
                                                    mods: { disabled: teaser.subscription ? 'yes' : '' },
                                                    content: [
                                                        {
                                                            block: 'button',
                                                            content: teaser.currencyPayed[0].text
                                                        },
                                                        {
                                                            elem: 'control',
                                                            content: teaser.currencyPayed.map(function(item) {
                                                                return {
                                                                    elem: 'option',
                                                                    attrs: { value: item.value },
                                                                    content: item.text
                                                                }
                                                            })
                                                        }
                                                    ]
                                                }
                                            ]
                                        ]
                                    },
                                    buttons && {
                                        elem: 'buttons-wrap',
                                        elemMods: {
                                            'icon-inside': teaser.prependIconToSelect ? 'yes' : 'no'
                                        },
                                        content: buttons
                                    }
                                ]
                            },
                            teaser.subscription && {
                                elem: 'subscription',
                                content: teaser.subscription.text
                            }
                        ]
                    },
                    teaser.footer && {
                        elem: 'footer',
                        content: teaser.footer
                    },
                    !!this.ctx.clientMustConvert && this.ctx.isInternalRole && {
                        block: 'b-icon-text',
                        mix: { block: 'b-teaser', elem: 'convert-warning' },
                        icon: { 'size-23': 'notice' },
                        content: iget2('b-teaser', 'interfeys-klienta-api-zablokirovany', 'Интерфейс клиента/API заблокированы тизером мультивалютности.')
                    }
                ]
            },
            teaser.linkText && {
                block: 'link',
                mix: [{ block: 'b-teaser', elem: 'link' }],
                mods: { pseudo: 'yes', theme: 'pseudo' },
                content: teaser.linkText
            }
        ];
    })

);
