block('b-teaser').mod('mode', 'video')(

    match(function() { return this.ctx.teaser; }).content()(function() {
        var teaser = this.ctx.teaser,
            mixes = this.ctx.mixes,
            buttons = (teaser.buttons || []).map(function(button) {
                return {
                    block: 'button',
                    mods: { theme: button.theme || 'normal' },
                    mix: [{
                        block: 'b-teaser',
                        elem: 'action-button'
                    }].concat(button.mixes, (mixes && mixes.button)),
                    attrs: {
                        target: button.target,
                        // в Gecko псевдоссылки все равно отрабатывают сначала как ссылки
                        // поэтому не используем url
                        link: button.link
                    },
                    content: button.text
                };
            });

        if (!teaser.noClose) {
            buttons.push({
                block: 'button',
                mods: { theme: 'clear' },
                mix: [
                    {
                        block: 'b-teaser',
                        elem: 'close-button'
                    }
                ].concat(mixes ? mixes.close : []),
                content: [
                    {
                        block: 'spin',
                        mods: { theme: 'gray-16' },
                        mix: mixes && mixes.spin
                    }, iget2('b-teaser', 'zakryt', 'Закрыть')
                ]
            });
        }

        return [
            {
                block: 'b-teaser',
                elem: 'wrap',
                content: [
                    {
                        elem: 'content',
                        content: [
                            {
                                elem: 'video',
                                videoUrl: teaser.videoUrl
                            },
                            {
                                elem: 'footer-wrap',
                                content: [
                                    teaser.title && {
                                        elem: 'title',
                                        content: teaser.title
                                    },
                                    buttons && {
                                        elem: 'buttons-wrap',
                                        content: buttons
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ]
    })

);
