block('b-teaser').mod('type', 'bs')(
    js()(function() {
        var data = this.ctx.data;

        return {
            showLink: data.linkshow,
            closeLink: data.close_counter
        };
    }),

    content()(function() {
        var mixes = this.ctx.mixes,
            data = this.ctx.data,
            icon = data.icon_svg,
            links = data.links,
            buttons = [
                'button_yes' in data && {
                    block: 'button',
                    mods: { theme: 'action' },
                    mix: mixes.button.concat([
                        {
                            block: 'b-teaser',
                            elem: 'action-button'
                        }
                    ]),
                    attrs: {
                        href: data.url
                    },
                    content: data.button_yes
                },
                {
                    block: 'button',
                    mods: { theme: 'clear' },
                    mix: mixes.close.concat([
                        {
                            block: 'b-teaser',
                            elem: 'close-button'
                        }
                    ]),
                    content: data.button_no
                }
            ],
            /**
             * Подставляет ссылки в текст тизера
             * Для тизеров существует следующее соглашение: ссылки в тексте обрамлены [квадратными скобками]
             * url-ы ссылок лежат отдельно (в этот блок приезщают как data.links)
             * insertLinks - замена оквадраченных слов на соответствующие ссылки
             * @param {String} text
             * @param {Steing[]} links
             * @returns {String}
             */
            insertLinks = function(text, links) {
                var index = 0;

                return text.replace(/\[(.+?)\]/g, function(match, linkText) {
                    return applyCtx({
                        block: 'link',
                        attrs: {
                            target: '_blank'
                        },
                        url: links[index++],
                        content: linkText
                    });
                });
            },
            textWithLinks = insertLinks(data.text, links);

        return [
            {
                block: 'b-teaser',
                elem: 'wrap',
                content: [
                    {
                        elem: 'content',
                        content: [
                            icon && {
                                elem: 'icon',
                                content: {
                                    block: 'b-icon',
                                    url: icon
                                }
                            },
                            {
                                elem: 'content-wrap',
                                content: [
                                    data.title && {
                                        elem: 'title',
                                        content: data.title
                                    },
                                    {
                                        elem: 'info',
                                        content: {
                                            elem: 'text',
                                            content: textWithLinks
                                        }
                                    },
                                    buttons && {
                                        elem: 'buttons-wrap',
                                        content: buttons
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
