/**
 * Настройки для мультивалютного тизера с выбором страны
 * Кнопки "отложить" нет, крестик скрыт - закрыть тизер (на попапе) нельзя
 */

block('b-teaser').mod('type', 'country-currency-choose').def()(function() {
    return applyNext({
        'ctx.teaser': {
            title: u['b-teaser'].getTeaserTitle('country-currency-choose'),

            mode: 'country-currency-choose',

            text: [
                iget2(
                    'b-teaser',
                    'perevedite-kampanii-v-tu',
                    'Переведите кампании в ту валюту, которой вы обычно платите, и управляйте рекламой, не пересчитывая значения в условные единицы. После перехода вы сможете продолжить работу с вашими рекламными кампаниями.'
                ),
                applyCtx({
                    block: 'b-choose-country-currency'
                })
            ],

            linkText: iget2('b-teaser', 'vedite-vashi-kampanii-v', 'Ведите ваши кампании в валюте оплаты'),

            subscription: this.data.cannot_request_currency_convert && {
                text: iget2(
                    'b-teaser',
                    'my-zhdem-uvedomlenie-o',
                    'Мы ждем уведомление о старте перевода в валюту от вашего агентства. Пожалуйста, обратитесь к менеджеру агентства.'
                )
            },
            buttons: !this.data.cannot_request_currency_convert && [
                {
                    text: iget2('b-teaser', 'perevesti-seychas', 'Перевести сейчас'),
                    mixes: [{
                        block: 'b-teaser',
                        elem: 'country-currency-choose-button'
                    }],
                    theme: 'action'
                }
            ],

            disableIcon: true,
            noClose: this.ctx.clientMustConvert && !this.ctx.isInternalRole
        }
    });
});
