block('b-teaser').mod('type', 'education').content()(function() {
    var mixes = this.ctx.mixes;

    return applyNext({
        'ctx.teaser': {
            title: {
                block: 'link',
                mix: mixes && mixes.link,
                url: '//yandex.ru/adv/edu/direct?utm_source=direct&utm_medium=product_new&utm_campaign=static',
                target: '_blank',
                content: this.ctx.titleText
            },
            // eslint-disable-next-line max-len
            text: iget2('b-teaser', 'uznayte-bolshe-o-rabote', 'Узнайте больше о работе с Директом из {help}, {webinar} и {videos}', {
                help: function(text) {
                    return {
                        block: 'link',
                        url: '//yandex.ru/support/direct/',
                        target: '_blank',
                        content: text
                    };
                }(iget2('b-teaser', 'uznayte-bolshe-o-rabote-param-help', 'помощи')),

                webinar: function(text) {
                    return {
                        block: 'link',
                        // eslint-disable-next-line max-len
                        url: '//yandex.ru/adv/edu/webinars?utm_source=direct&utm_medium=product_new&utm_campaign=static',
                        target: '_blank',
                        content: text
                    };
                }(iget2('b-teaser', 'uznayte-bolshe-o-rabote-param-webinar', 'регулярных вебинаров')),

                videos: function(text) {
                    return {
                        block: 'link',
                        url: '//youtube.com/c/YandexADV',
                        target: '_blank',
                        content: text
                    }
                }(iget2('b-teaser', 'uznayte-bolshe-o-rabote-param-videos', 'обучающих видеозаписей.')),

                context: 'help - помощи; webinar - регулярных вебинаров; videos - обучающих видеозаписей.'
            }),
            buttons: [
                {
                    theme: 'action',
                    link: '//yandex.ru/adv/edu/direct?utm_source=direct&utm_medium=product_new&utm_campaign=static',
                    target: '_blank',
                    text: iget2('b-teaser', 'onlayn-kurs', 'Онлайн-курс'),
                    mixes: { block: 'b-teaser', elem: 'education-action' }
                }
            ]
        }
    });
});
