BEM.DOM.decl({ name: 'b-teaser', modName: 'type', modVal: 'email-collector' }, {

    onSetMod: {
        js: function() {
            this._request = BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                type: 'GET',
                dataType: 'json',
                cache: false,
                callbackCtx: this
            });

            this._emailInput = this.findBlockOn('email-input', 'input');

            this._subscribeBtn = this.findBlockOn('subscribe-button', 'button');

            this._initEvents();

            BEM.blocks['b-metrika2'].params({
                params: {
                    ShowCamps: 'emailCollectorTeaserShown'
                }
            });
        }
    },

    /**
     * Выполняет подписку на события через i-subscription-manager
     * @private
     */
    _initEvents: function() {
        this._subscribeManager = BEM.create('i-subscription-manager');

        this._subscribeManager
            .on(this._emailInput, 'change', function(e) {
                this._clearStatus()
                    ._toggleSendBtnAvailability(!e.block.val())
            }, this);
    },

    /**
     * Проверяет значение инпута на соответствие коррекному email адресу.
     * @returns {$.Deferred}
     * @private
     */
    _validateInput: function() {
        var deferred = $.Deferred(),
            val = this._emailInput.val();

        u.emailRegExp().test(val) ?
            deferred.resolve(val) :
            deferred.reject(iget2('b-teaser', 'nekorrektno-ukazan-email', 'Некорректно указан email'));

        return deferred;
    },

    /**
     * Обновляет элемент отображения статуса сохранения.
     * @param {Object} status - объект состояния { statusType: statusText }
     * @returns {BEM}
     * @private
     */
    _refreshStatus: function(status) {
        var type = Object.keys(status)[0];

        this.setMod(this.elem('status'), 'view', type);
        this.elem('status').text(status[type]);

        return this;
    },

    /**
     * Очищает элемент отображения статуса сохранения.
     * @returns {BEM}
     * @private
     */
    _clearStatus: function() {
        this.delMod(this.elem('status'), 'view');
        this.elem('status').text('');

        return this;
    },

    /**
     * Выполняет ajax запрос для сохранения email.
     * @param {String} email - адрес
     * @private
     */
    _sendSubscribeRequest: function(email) {
        this._request.get({
            cmd: 'ajaxSetRecommendationsEmail',
            recommendations_email: email
        }, function(resp) {
            this
                ._refreshStatus( resp.ok ?
                    { success: iget2('b-teaser', 'el-adres-s-uspeshno', 'Эл. адрес {foo} успешно сохранен.', {
                        foo: email
                    }) } :
                    { error: resp.error })
                ._togglePending(false);

            setTimeout(this._close.bind(this), 1200);
        }, function() {
            this._refreshStatus({ error: iget2('b-teaser', 'oshibka-sohraneniya-povtorite-popytku', 'Ошибка сохранения, повторите попытку позже') })
                ._togglePending(false);
        });
    },

    /**
     * Выполняет ajax запрос чтобы больше не показывать тизер.
     * @override
     * @private
     */
    _onClose: function() {
        this._request.get({
            cmd: 'ajaxUserOptions',
            hide_recommendations_email_teaser: 1
        }, function() { });
    },

    /**
     * Блокирует инпут и кнопку.
     * Обновляет текст кнопки для индикации процесса сохранения.
     * @param {Boolean} flag - флаг для установки состояния
     * @returns {BEM}
     * @private
     */
    _togglePending: function(flag) {
        this._toggleSendBtnAvailability(flag)
            ._toggleEmailInputAvailability(flag);

        this.setMod(this.elem('subscribe-button'), 'view', flag ? 'pending' : '');

        return this;
    },

    /**
     * Переключает доступность кнопки
     * @param {Boolean} flag - флаг для установки состояния
     * @returns {BEM}
     * @private
     */
    _toggleSendBtnAvailability: function(flag) {
        this._subscribeBtn.setMod('disabled', flag ? 'yes' : '');

        return this;
    },

    /**
     * Переключает доступность инпута ввода
     * @param {Boolean} flag - флаг для установки состояния
     * @returns {BEM}
     * @private
     */
    _toggleEmailInputAvailability: function(flag) {
        this._emailInput.setMod('disabled', flag ? 'yes' : '');

        return this;
    },

    /**
     * Обработчик клика по кнопке "Подписаться".
     * Если строка соответствует корректному email, выполняет сохранение, иначе выводит ошибку.
     * @returns {BEM}
     * @private
     */
    _subscribe: function() {
        this._clearStatus();

        this._validateInput()
            .then(function(email) {
                BEM.blocks['b-metrika2'].params({
                    params: {
                        ShowCamps: 'emailCollectorTeaserApplyButtonClicked'
                    }
                });

                this._togglePending(true)
                    ._sendSubscribeRequest(email);
            }.bind(this))
            .fail(function(error) {
                this._refreshStatus({ error: error });
            }.bind(this));
    },

    destruct: function() {
        this._subscribeManager.dispose();
        this.__base.apply(this, arguments);
    }
});
