/**
 * Настройки для мультивалютного тизера (обычного без выбора страны)
 * Кнопки "отложить" нет, крестик скрыт - закрыть тизер (на попапе) нельзя
 */

block('b-teaser').mod('type', 'multicurrency').def()(function() {
    var data = this.data,
        countryId = data.countries[0].region_id,
        currencies = data.countries_currencies,
        currencyPayed = currencies[countryId] || [],
        oneCurrency = currencyPayed.length == 1,
        firstCurrencyPayed = currencyPayed[0],
        moveMoneyLinkParams = {
            ulogin: data.FORM.ulogin,
            country: data.countries[0].region_id
        };

    firstCurrencyPayed && (moveMoneyLinkParams.currency = firstCurrencyPayed);

    return applyNext({
        'ctx.teaser': {
            title: oneCurrency ?
                u.currencies.getText(firstCurrencyPayed, 'multicurrency_teaser_title') :
                u['b-teaser'].getTeaserTitle('multicurrency'),
            mode: 'multicurrency',
            text: iget2(
                'b-teaser',
                'perevedite-kampanii-v-tu',
                'Переведите кампании в ту валюту, которой вы обычно платите, и управляйте рекламой, не пересчитывая значения в условные единицы. После перехода вы сможете продолжить работу с вашими рекламными кампаниями.'
            ),
            linkText: iget2('b-teaser', 'vedite-vashi-kampanii-v', 'Ведите ваши кампании в валюте оплаты'),
            currencyIconType: oneCurrency ? firstCurrencyPayed : '',

            subscription: this.data.cannot_request_currency_convert && {
                text: iget2(
                    'b-teaser',
                    'my-zhdem-uvedomlenie-o',
                    'Мы ждем уведомление о старте перевода в валюту от вашего агентства. Пожалуйста, обратитесь к менеджеру агентства.'
                )
            },
            disableIcon: !oneCurrency,
            prependIconToSelect: true,

            buttons: !this.data.cannot_request_currency_convert && [
                oneCurrency ?
                    {
                        text: iget2('b-teaser', 'perevesti-seychas', 'Перевести сейчас'),
                        link: u.getUrl('moveToRealMoney', moveMoneyLinkParams),
                        mixes: [{
                            block: 'b-teaser',
                            elem: 'multicurrency-button'
                        }],
                        theme: 'action'
                    } :
                    {
                        text: iget2('b-teaser', 'perevesti-seychas', 'Перевести сейчас'),
                        mixes: [{
                            block: 'b-teaser',
                            elem: 'multicurrency-button',
                            elemMods: {
                                with: 'select'
                            }
                        }],
                        theme: 'action'
                    }
            ],
            noClose: this.ctx.clientMustConvert && !this.ctx.isInternalRole,
            currencyPayed: currencyPayed.map(function(value) {
                return {
                    value: value,
                    text: u.currencies.getName(value, {
                        full: true
                    })
                };
            })
        }
    });
});
