block('b-teaser').def().match(function() {
    return !this.ctx._defApplied;
})(function() {
    var teaserMode = this.data.show_teaser,
        emailTeaserEditions = ['gym', 'plane', 'battery'],
        // не показываем тизер для сбора электронных адресов, если приходит hide_recommendations_email_teaser от сервера
        // (приходит в случае, если пользователь уже видел тизер и ввел почту, либо закрыл тизер)
        isHidden = (teaserMode === 'recommendations_email') &&
            +this.data.USER_OPTIONS.hide_recommendations_email_teaser,
        isMultiCurrency = u._.includes([
            'country-currency-choose',
            'multicurrency',
            'recommendations_email'
        ], teaserMode),
        countries,
        params,
        isInternalRole = hasLoginRights('super_control', 'superreader_control', 'manager_control', 'media_control',
            'support_control');

    // оставляем старые тизеры только мультивалютные
    if (!isMultiCurrency || isHidden) return applyNext();

    params = {
        ulogin: u.escapeHTML(this.data.FORM.ulogin)
    };

    countries = this.data.countries;

    switch (teaserMode) {
        case 'recommendations_email':
            teaserMode = 'email-collector';
            break;

        case 'multicurrency':
            countries.length > 1 && (teaserMode = 'country-currency-choose');
            params.country = countries[0].region_id;
            break;
    }

    return applyCtx({
        block: 'b-teaser',
        _defApplied: true,
        mods: {
            view: 'full',
            mode: 'regular',
            type: teaserMode,
            'under-paranja': this.data.client_must_convert && !isInternalRole ? 'yes' : 'no',
            edition: emailTeaserEditions[u._.random(emailTeaserEditions.length - 1)],
            lang: this.data.lang,
            infoblock: this.ctx.mods && this.ctx.mods.infoblock
        },
        mix: this.ctx.mix || [],
        js: params,
        clientMustConvert: this.data.client_must_convert,
        isInternalRole: isInternalRole
    });
});
