BEM.DOM.decl('b-teaser', {

    /**
     * Переход на страницу конвертации валюты
     * @param {String} [type]
     */
    _multicurrencySubmit: function(type) {
        var country,
            currency,
            currencyCountry;

        if (type == 'choose') {
            currencyCountry = this.findBlockInside('info', 'b-choose-country-currency');
            country = currencyCountry.elem('country-hidden').val();
            currency = currencyCountry.elem('currency-hidden').val();
        } else {
            country = this.params.country;
            currency = this.findBlockInside('multicurrency-select', 'select').val();
        }

        if (country && currency) {
            var params = {
                cmd: 'moveToRealMoney',
                country: country,
                currency: currency,
                ulogin: this.params.ulogin
            };

            BEM.create({ block: 'i-request', mods: { type: 'form' } }, {
                url: '/registered/main.pl',
                type: 'get'
            }).submit(params);
        } else {
            BEM.blocks['b-confirm'].open({
                type: 'alert',
                message: !country ?
                    iget2('b-teaser', 'pozhaluysta-ukazhite-iz-kakoy', 'Пожалуйста, укажите из какой вы страны') :
                    iget2('b-teaser', 'pozhaluysta-ukazhite-valyutu', 'Пожалуйста, укажите валюту')
            }, this);
        }
    },

    /**
    * Скрывает тизер (только для тизеров вне инфоблока)
    * @private
    */
    _close: function() {
        this.getMod('infoblock') == 'yes' || this.toggleMod('view', 'short', 'full', this.getMod('view') === 'full');
    },

    /**
     * Выполняет действия по клику на крестик
     * Переопределяется в модификаторах
     * @private
     */
    _onClose: function() {}
}, {

    live: function() {
        this
            .liveBindTo('link close close-button', 'click', function() {
                this._close();
            })
            .liveBindTo({ elem: 'multicurrency-button', modName: 'with', modVal: 'select' }, 'click', function() {
                this._multicurrencySubmit();
            })
            .liveBindTo('country-currency-choose-button', 'click', function() {
                this._multicurrencySubmit('choose');
            })
            .liveBindTo('subscribe-button', 'click', function() {
                this._subscribe();
            })
            .liveBindTo('close-button', 'click', function() {
                this._onClose();
            });
    }

});
