BEM.DOM.decl('b-text-panel', {

    onSetMod: {
        folded: function(modName, modVal) {
            this.afterCurrentEvent(function() {
                this.trigger('folded', {
                    value: modVal === 'yes',
                    modVal: modVal
                });
            });
        }
    },

    _onToggleClick: function() {
        this.toggleMod('folded', 'yes', 'no');
    },

    _onTopClick: function(e, data) {
        var selection = window.getSelection(),
            hasSelectionText = selection && selection.type === 'Range' &&
                $(selection.focusNode).parent(this.buildSelector('on-top')).length;

        /* Если нет выделения текста в элементе `on-top` - считаем за обычный клик */
        if (!hasSelectionText) {
            this._onToggleClick();
        }
    }

}, {

    live: function() {
        this
            .liveBindTo('toggle', 'pointerclick', function(e, data) {
                this._onToggleClick(e, data);
            })
            .liveBindTo('on-top', 'pointerclick', function(e, data) {
                this._onTopClick(e, data);
            });
    }

});
