/**
 * @fires b-time-targeting-decorator#save Событие клика по кнопке сохранения
 * @fires b-time-targeting-decorator#cancel Событие клика по кнопке отмены
 */
BEM.DOM.decl({ block: 'b-time-targeting-decorator', implements: 'i-modal-popup-inner-block-interface' }, {

    onSetMod: {

        js: function() {
            this._timeTargetingBlock = this.findBlockInside('b-time-targeting');
        }

    },

    /**
     * Возвращает флаг наличия изменений в промисе
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(this.hasChanges());

        return deferred.promise();
    },

    /**
     * Возвращает флаг наличия изменений в промисе
     * @returns {Boolean}
     */
    hasChanges: function() {
        return this._timeTargetingBlock.isChanged();
    },

    /**
     * Проксируем метод фиксирования изменений
     * Блокируем кнопку сохранения
     */
    fixChanges: function() {

        return this._timeTargetingBlock.fixChanges();
    },

    /**
     * Проксируем метод отмены изменений
     * Блокируем кнопку сохранения
     */
    cancel: function() {

        return this._timeTargetingBlock.cancel();
    },

    /**
     * Проксируем метод установки доступности расширенного режима настроек
     */
    setExtendModeAvailable: function() {
        return this._timeTargetingBlock.setExtendModeAvailable.apply(this._timeTargetingBlock, arguments);
    },

    /**
     * Проксируем метод получения значения
     */
    getValue: function() {
        return this._timeTargetingBlock.getValue();
    },

    /**
     * Обработчик изменения блока `b-time-targeting`
     * @param {jQuery.Event} e
     * @param {Object} data
     * @param {Boolean} data.isChanged
     * @private
     */
    _onTimeTargetingChange: function(e, data) {

    },

    /**
     * Возвращает кнопку сохранения
     * @returns {BEM.DOM}
     * @private
     */
    _getSaveButton: function() {
        return this._saveButton || (this._saveButton = this.findBlockOn('footer-button-save', 'button'));
    },

    /**
     * Обработчик клика по кнопке сохранения
     * @private
     */
    _onSaveClick: function() {
        this.trigger('save');
    },

    /**
     * Обработчик клика по кнопке отмены
     * @private
     */
    _onCancelClick: function() {
        this.trigger('cancel');
    },

    /**
     * Обработчик клика по кнопкам в футере
     * @private
     */
    _onFooterButtonClick: function(e) {
        var block = e.block,
            domElem = block.domElem;

        if (this.elem('footer-button-save').is(domElem)) {
            this._saveButton = block;

            this._onSaveClick();
        } else if (this.elem('footer-button-cancel').is(domElem)) {
            this._onCancelClick();
        }
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button', function(e) {
                this._onFooterButtonClick(e);
            })
            .liveInitOnBlockInsideEvent('change', 'b-time-targeting', function(e, data) {
                this._onTimeTargetingChange(e, data);
            });

        return false;
    }

});
