/**
 *
 * @event b-time-targeting-presenter#popup-show popup стал виден
 * @event b-time-targeting-presenter#save-click клик по кнопке "Сохранить"
 *
 * @fires b-time-targeting-presenter#popup-show
 * @fires b-time-targeting-presenter#save-click
 */
BEM.DOM.decl('b-time-targeting-presenter', {

    onSetMod: {

        js: function() {
            this._timeTargetingData = this.params.timeTargetingData;

            this._toggleListenChangeStrategy('on');
        }

    },

    /**
     * Изменяли ли значение временного таргетинга
     * @returns {boolean}
     */
    isChanged: function() {
        return this._timeTargetingDecorator ?
            (this._isTimeTargetingValueFixed ? true : this._timeTargetingDecorator.hasChanges()) :
            false;
    },

    /**
     * Возвращает и кеширует модель кампании
     * @returns {Object}
     * @private
     */
    _getModelCampaign: function() {
        if (this._modelCampaign) {
            return this._modelCampaign;
        }
        this._modelCampaign = BEM.MODEL.getOrCreate(this.params.campModelParams);

        return this._modelCampaign;
    },

    /**
     * Подписывается/отписывается на изменение стратегии
     * @param {String} methodName
     * @private
     */
    _toggleListenChangeStrategy: function(methodName) {
        var modelCampaign = this._getModelCampaign(),
            strategyModel = modelCampaign.get('strategy2');

        // в новом формате организации данных стратегии флаг автобюджетной стратегии
        // хранится в модели самой стратегии
        strategyModel && strategyModel[methodName]('is_autobudget', 'change', this._onAutobudgetChange, this);

        // @deprecated (осталось так как некоторые контролы еще не переехали на новую стратегию)
        modelCampaign[methodName]('is_autobudget', 'change', this._onAutobudgetChange, this);
    },

    /**
     * Обработчик изменения стратегии
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onAutobudgetChange: function(e, data) {
        var campaignMediaType = this._getModelCampaign().get('mediaType'),
            isExtendModeAvailable = u.campaign.isCpm(campaignMediaType) ? false : !data.value;

        this._timeTargetingData.isExtendModeAvailable = isExtendModeAvailable;

        // Если блок уже сгенерирован и проинициализирован
        if (this._timeTargetingDecorator) {
            this._timeTargetingDecorator.setExtendModeAvailable(isExtendModeAvailable);
        }

        this._updateElem('text-value');
        this._updateElem('form-fields');
    },

    /**
     * Обработчик клика по кнопке изменения
     * @param {jQuery.Event} e
     * @private
     */
    _onButtonClick: function(e) {
        if (this.elem('opener').is(e.block.domElem)) {
            this._showPopup();
        }
    },

    /**
     * Создает попап
     * @private
     */
    _createPopup: function() {
        var popupDecorator = BEM.DOM.blocks['b-modal-popup-decorator']
                .create({ 'overflow-x': 'hidden' }, { bodyScroll: false }),
            timeTargetingDecorator = popupDecorator.setPopupContent({
                block: 'b-time-targeting-decorator',
                params: this._timeTargetingData
            });

        timeTargetingDecorator
            .on('save', this._onTimeTargetingSave, this)
            .on('cancel', this._onTimeTargetingCancel, this);

        popupDecorator
            .on('close-blocked', this._onPopupDecoratorCloseBlocked, this)
            .on('close', this._onPopupDecoratorClose, this);

        popupDecorator._popup.on('show', function() {
            this.trigger('popup-show');
        }, this);

        this._popupDecorator = popupDecorator;
        this._timeTargetingDecorator = timeTargetingDecorator;
    },

    /**
     * Показывает попап
     * @private
     */
    _showPopup: function() {
        if (!this._popupDecorator) {
            this._createPopup();
        }

        this._popupDecorator.show();
    },

    /**
     * Обработчик закрытия попапа при наличии изменений в блоке
     * @private
     */
    _onPopupDecoratorCloseBlocked: function() {
        var popupDecorator = this._popupDecorator,
            bemPopup = popupDecorator.getPopup();

        BEM.DOM.blocks['b-confirm'].open({
            title: iget2('b-time-targeting-presenter', 'est-nesohranyonnye-izmeneniya', 'Есть несохранённые изменения'),
            question: iget2('b-time-targeting-presenter', 'vy-deystvitelno-hotite-zakryt', 'Вы действительно хотите закрыть?'),
            message: [],
            fromPopup: bemPopup,
            onYes: function() {
                popupDecorator.hide({ force: true });
            }
        });
    },

    /**
     * Обработчик закрытия попапа
     * @private
     */
    _onPopupDecoratorClose: function() {
        this._timeTargetingDecorator.cancel();
    },

    /**
     * Обработчик события сохранения изменений блока
     * @param {jQuery.Event} e
     * @private
     */
    _onTimeTargetingSave: function(e) {
        var value = this._timeTargetingDecorator.getValue();

        this.trigger('save-click');

        if (!value.error) {
            // Фиксируем значение, чтобы при последующем открытии сохраненное значение было изначальным
            this._timeTargetingDecorator.fixChanges();
            this._isTimeTargetingValueFixed = true;
            this._timeTargetingData.value = value;

            this._popupDecorator.hide({ force: true });

            this._updateElem('text-value');
            this._updateElem('form-fields');
        }
    },

    /**
     * Обработчик события отмены изменений блока
     * @private
     */
    _onTimeTargetingCancel: function() {
        // DIRECT-59123: отмена закрывает попапы с force
        this._popupDecorator.hide({ force: true });
    },

    /**
     * Перерисовывает элемент
     * @param {String} elemName
     * @private
     */
    _updateElem: function(elemName) {
        BEM.DOM.replace(this.findElem(elemName), BEMHTML.apply({
            block: this.__self.getName(),
            elem: elemName,
            mix: elemName == 'text-value' ? this.params.hintMixes || [] : [],
            params: this._timeTargetingData
        }));
    },

    destruct: function() {
        this._toggleListenChangeStrategy('un');

        this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button', function(e) {
            this._onButtonClick(e);
        });

        // Нужно для подписки на изменение стратегии
        return false;
    }

});
