(function() {

        /**
         * Отдает время показа в виде строки.
         *
         * @param {String} code Код таргетинга.
         * @returns {String}
         */
    var getTextDayHours = function(code) {
            var codesOfDays = getCodesOfDays(code),
                leader = null,
                trailer,
                texts = [];

            for (var dayIndex = 0; dayIndex < 7; dayIndex++) {
                var codeDay = codesOfDays[dayIndex];

                if (codeDay) {
                    // начало последовательности
                    leader === null && (leader = dayIndex);

                    // если последовательность не начнется, замыкаем и начинаем новую
                    if (codesOfDays[dayIndex] != codesOfDays[dayIndex + 1]) {
                        trailer = dayIndex;
                        texts.push(getTextDayRange(leader, trailer) + ': ' + getTextDayTime(codeDay));
                        leader = null;
                    }
                }
            }

            return texts.join(', ');
        },

        /**
         * Возвращает форматированное значение промежутка времени
         * @param {Number} leader
         * @param {Number} trailer
         * @returns {String}
         */
        getHoursIntervalText = function(leader, trailer) {
            var getFormattedHours = u['b-time-targeting'].getFormattedHours;

            return getFormattedHours(leader) + '-' + getFormattedHours(trailer);
        },

        /**
         * Отдает время показа в виде строки за определенный день.
         *
         * @param {String} codeDay Код таргетинга за определенный день.
         * @returns {String}
         */
        getTextDayTime = function(codeDay) {
            var day = [],
                leader = null,
                trailer;

            u['b-time-targeting'].FULL_HOUR_CODES.forEach(function(hourCode, index) {
                if (~codeDay.indexOf(hourCode)) {
                    // проверяем на null, потому что 0 для нас true
                    leader === null && (leader = index);

                    // если отмечен последний час, замыкаем последовательность и сбрасываем лидирующий час
                    index === 23 && (trailer = 24) &&
                        day.push(getHoursIntervalText(leader, trailer)) && (leader = null);
                } else {
                    // если есть последовательность, замыкаем и сбрасываем лидирующий час
                    (trailer = index) && leader !== null &&
                        day.push(getHoursIntervalText(leader, trailer)) && (leader = null);
                }
            });

            return day.join(', ');
        },

        /**
         * Отдает коды временного таргетинга по дня, с соответствием индексов WEEKDAY_NAMES.
         *
         * @param {String} code Код временного таргетинга.
         * @returns {Array}
         */
        getCodesOfDays = function(code) {
            var codesNormalized = [],
                codes = code.replace(/[a-z]+/g, '').match(/\d[A-X]+/g);

            codes && codes.forEach(function(code) {
                var split = code.match(/\d|[A-X]+/g);

                codesNormalized[split[0] - 1] = split[1];
            });

            return codesNormalized;
        },

        /**
         * Отдает дневной промежуток вида "пн.-сб." на основе индексов дней недели.
         *
         * @param {Number} from Индекс начала дня недели.
         * @param {Number} to Индекс конца дня недели.
         * @returns {String}
         */
        getTextDayRange = function(from, to) {
            var indexweekday = u['b-time-targeting'].INDEX_WEEKDAY;

            return indexweekday[from] + (from != to ? '-' + indexweekday[to] : '');
        },

        /**
         * Отдает текст диапазона времени показа в праздничные дни.
         *
         * @param {Number} hourFrom Час начла показа.
         * @param {Number} hourTo Час конца показа.
         * @returns {String}
         */
        getTextShowOnHoliday = function(hourFrom, hourTo) {
            return hourFrom !== undefined && hourTo !== undefined ?
                hourFrom === 0 && hourTo === 24 ?
                    iget2('b-time-targeting-view', 'kruglosutochno', 'круглосуточно') :
                    iget2('b-time-targeting-view', 'pokazyvat-s-s-do', 'показывать с {foo} до {bar}', {
                        foo: u['b-time-targeting'].getFormattedHours(hourFrom),
                        bar: u['b-time-targeting'].getFormattedHours(hourTo)
                    }) :
                '';
        },

        /**
         * Отдает уровень цены клика в праздничные дни в виде текста.
         *
         * @param {String} level Уровень цены клика.
         * @returns {string}
         */
        getTextClickLevel = function(level) {
            level = +level;

            return level === 0 || level === 100 ?
                '' :
                ' (' + iget2('b-time-targeting-view', 'ogranichenie-stavki-na', 'ограничение ставки на уровне') + ' ' + u.escapeHTML(level) + '%)';
        },
        /**
         * Чистит код временного таргетинга от уровня цен.
         *
         * @param {String} code Код временного таргетинга.
         * @returns {String}
         */
        getCleanCode = function(code) {
            return code.replace(/[a-z]/g, '');
        };

    u.register({

        'b-time-targeting-view': {

            /**
             * Возвращает текстовое представление значения временного таргетинга
             * @param {Object} timeTargetData
             * @returns {String[]}
             */
            getText: function(timeTargetData) {
                var texts = [],
                    value = timeTargetData.value,
                    targetCode = value.timeTargetCode,
                    holidaySettings = value.holidayShowSettings,
                    isAllTime = getCleanCode(targetCode) === u['b-time-targeting'].CODE_ALL_TIME,
                    text;

                texts.push(isAllTime ?
                    iget2('b-time-targeting-view', 'kruglosutochno-124', 'Круглосуточно') :
                    iget2('b-time-targeting-view', 'pokazyvat', 'Показывать') + ': ' + getTextDayHours(targetCode)
                );

                if (value.isHolidaySettingsEnabled) {
                    text = iget2('b-time-targeting-view', 'po-prazdnikam', 'По праздникам') + ': ';

                    if (holidaySettings.isShowing) {
                        text += getTextShowOnHoliday(holidaySettings.showingFrom, holidaySettings.showingTo);

                        if (timeTargetData.isExtendModeAvailable && value.isExtendModeOn) {
                            text += getTextClickLevel(holidaySettings.coefficient);
                        }
                    } else {
                        text += iget2('b-time-targeting-view', 'ne-pokazyvat', 'не показывать');
                    }

                    texts.push(text);
                }

                /* убрано в DIRECT-61541
                if (value.isWorkingWeekendEnabled) {
                    texts.push(iget('Рабочие выходные: по расписанию перенесенного буднего дня'));
                } */

                if (!isAllTime || (value.isHolidaySettingsEnabled && holidaySettings.isShowing)) {
                    texts.push(iget2('b-time-targeting-view', 'vremya', 'Время') + ': ' + value.timeZone.text);
                }

                if (timeTargetData.isExtendModeAvailable && (/[a-z]/).test(targetCode)) {
                    texts.push(iget2('b-time-targeting-view', 'dobavlena-korrektirovka-stavki-po', 'Добавлена корректировка ставки по времени'));
                }

                return texts;
            }

        }

    });

})();
