// использовался в ЛИ, поддержку я впилила на всякий случай
block('b-time-targeting-worktime')(

    js()(true),

    content()(function() {
        var value = this.ctx.value,
            hourCodes = u['b-time-targeting'].FULL_HOUR_CODES,
            parsedTime = u['b-time-targeting'].parseFromCode(value),
            workdays = parsedTime.filter(function(day) {
                return day.hours.length > 0;
            }),
            dayFrom = workdays[0],
            dayTo = workdays[workdays.length - 1],
            dayFromHourFrom = dayFrom.hours[0],
            dayToHoursTo = dayTo.hours[dayTo.hours.length - 1];

        return [
            {
                elem: 'day',
                tag: 'span',
                content: iget2('b-time-targeting-worktime', 'c-day-from-po', 'C {day_from} по {day_to}', {
                    day_from: {
                        block: 'b-time-targeting-worktime',
                        tag: 'span',
                        elem: 'days-from',
                        content: {
                            block: 'b-time-targeting-worktime',
                            elem: 'select',
                            elemMods: { type: 'days-from' },
                            value: dayFrom.day,
                            options: u['b-time-targeting-worktime'].DAYS_FROM_NAMES
                        }
                    },

                    day_to: {
                        block: 'b-time-targeting-worktime',
                        tag: 'span',
                        elem: 'days-to',
                        content: {
                            block: 'b-time-targeting-worktime',
                            elem: 'select',
                            elemMods: { type: 'days-to' },
                            value: dayTo.day,
                            minValue: dayFrom.day,
                            options: u['b-time-targeting-worktime'].DAYS_TO_NAMES
                        }
                    }
                })
            },
            {
                elem: 'time',
                tag: 'span',
                content: [
                    {
                        block: 'icon',
                        mix: {
                            block: 'b-time-targeting-worktime',
                            elem: 'time-icon'
                        },
                        mods: {
                            'size-12': 'time'
                        }
                    },
                    {
                        block: 'b-time-targeting-worktime',
                        tag: 'span',
                        elem: 'hours-from',
                        content: {
                            block: 'b-time-targeting-worktime',
                            elem: 'select',
                            type: 'time',
                            elemMods: { type: 'hours-from' },
                            value: hourCodes.indexOf(dayFromHourFrom),
                            options: u['b-time-targeting-worktime'].HOURS_FROM_NAMES
                        }
                    },
                    '&nbsp;&mdash;&nbsp;',
                    {
                        block: 'b-time-targeting-worktime',
                        tag: 'span',
                        elem: 'hours-to',
                        content: {
                            block: 'b-time-targeting-worktime',
                            elem: 'select',
                            type: 'time',
                            elemMods: { type: 'hours-to' },
                            value: hourCodes.indexOf(dayToHoursTo) + 1,
                            minValue: hourCodes.indexOf(dayFromHourFrom) + 1,
                            options: u['b-time-targeting-worktime'].HOURS_TO_NAMES
                        }
                    }
                ]
            }
        ];
    }),

    elem('hours-codes')(function() {
        return u['b-time-targeting-worktime'].HOURS_CODES;
    }),

    elem('select').def()(function() {
        var ctx = this.ctx,
            minValue = ctx.minValue,
            isTimeControl = ctx.type == 'time',
            value = minValue && (minValue > ctx.value) ? minValue : ctx.value;

        return applyCtx({
            block: 'select',
            mods: { width: isTimeControl ? '100' : '' },
            mix: {
                block: 'b-time-targeting-worktime',
                elem: 'select',
                elemMods: this.elemMods
            },
            content: [
                {
                    block: 'button',
                    content: ctx.options[isTimeControl ? value : value - 1] // понедельник соответствует единице
                },
                {
                    elem: 'control',
                    attrs: { autocomplete: 'off' },
                    content: ctx.options.map(function(name, i) {
                        var optionValue = isTimeControl ? i : i + 1,
                            attrs = { value: optionValue };

                        if (optionValue === value) attrs.selected = 'selected';

                        return minValue && (optionValue < minValue) ?
                            '' :
                            {
                                elem: 'option',
                                attrs: attrs,
                                content: name
                            };
                    }, this)
                }
            ]

        });
    })
);
